/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class ObjectMethodMatchConf {
    public static final int INT_CONVERT = 1;
    public static final int LONG_CONVERT = 2;
    public static final int DOUBLE_CONVERT = 3;
    public static final int FLOAT_CONVERT = 4;
    public static final int SHORT_CONVERT = 5;
    public static final int BIGDECIMAL_CONVERT = 6;
    public static final int BYTE_CONVERT = 7;
    public static final int CHAR_CONVERT = 8;
    public static final int NO_CONVERT = 0;
    public static final int VARIABLE_ARRAY = 9;
    public Method method;
    public int[] convert;
    public boolean isNeedConvert;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.method.toString());
        sb.append(",");
        String sep = "";
        for (int i : this.convert) {
            sb.append(sep).append(i);
            sep = ",";
        }
        return sb.toString();
    }

    public Object[] convert(Object[] args) {
        if (this.isNeedConvert) {
            Object[] newArgs = new Object[this.convert.length];
            for (int i = 0; i < this.convert.length; ++i) {
                if (this.convert[i] != 9) {
                    Object obj;
                    newArgs[i] = obj = this.convert(args[i], i);
                    continue;
                }
                Class<?> c = this.method.getParameterTypes()[i].getComponentType();
                Object arrayObj = Array.newInstance(c, args.length - i);
                Object[] objs = new Object[args.length - i];
                for (int j = 0; j < objs.length; ++j) {
                    Array.set(arrayObj, j, args[i + j]);
                }
                newArgs[i] = arrayObj;
            }
            return newArgs;
        }
        return args;
    }

    private Object convert(Object o, int i) {
        switch (this.convert[i]) {
            case 0: {
                return o;
            }
            case 1: {
                return ((Number)o).intValue();
            }
            case 7: {
                return ((Number)o).byteValue();
            }
            case 8: {
                return Character.valueOf(((Character)o).charValue());
            }
            case 2: {
                return ((Number)o).longValue();
            }
            case 3: {
                return ((Number)o).doubleValue();
            }
            case 4: {
                return Float.valueOf(((Number)o).floatValue());
            }
            case 5: {
                return ((Number)o).shortValue();
            }
            case 6: {
                return new BigDecimal(o.toString());
            }
        }
        throw new RuntimeException("not support converty type " + i);
    }
}

