/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.Function;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.fun.FileFunctionWrapper;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.VarAttribute;

public class FunctionExpression
extends Expression {
    protected String name;
    public Expression[] exps;
    public VarAttribute[] vas;
    public Expression safeExp;
    protected boolean hasSafe = false;

    public FunctionExpression(String name, Expression[] exps, VarAttribute[] vas, boolean hasSafe, Expression safeExp, GrammarToken token) {
        super(token);
        this.name = name;
        this.exps = exps;
        this.vas = vas;
        this.safeExp = safeExp;
        this.hasSafe = hasSafe;
    }

    @Override
    public Object evaluate(Context ctx) {
        Function fn = ctx.gt.getFunction(this.name);
        if (fn == null) {
            Resource resource = this.getResource(ctx.gt, this.name);
            if (resource != null && resource.getResourceLoader().exist(resource.getId())) {
                fn = new FileFunctionWrapper(resource.getId().toString());
            } else {
                throw new BeetlException("FUNCTION_NOT_FOUND").pushToken(this.token);
            }
        }
        Object[] paras = new Object[this.exps.length];
        for (int i = 0; i < paras.length; ++i) {
            paras[i] = this.exps[i].evaluate(ctx);
        }
        Object value = null;
        try {
            value = fn.call(paras, ctx);
        }
        catch (BeetlException ex) {
            throw ex.pushToken(this.token);
        }
        catch (RuntimeException ex) {
            throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u8c03\u7528\u65b9\u6cd5\u51fa\u9519 " + this.name, ex).pushToken(this.token);
        }
        if (this.vas != null) {
            for (VarAttribute attr : this.vas) {
                try {
                    value = attr.evaluate(ctx, value);
                }
                catch (BeetlException ex) {
                    throw ex.pushToken(attr.token);
                }
                catch (RuntimeException ex) {
                    throw new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex).pushToken(attr.token);
                }
                if (value != null) continue;
                if (this.hasSafe) {
                    return this.safeExp == null ? null : this.safeExp.evaluate(ctx);
                }
                throw new BeetlException("ERROR", "\u7a7a\u6307\u9488 ").pushToken(attr.token);
            }
        }
        if (value == null && this.hasSafe) {
            return this.safeExp == null ? null : this.safeExp.evaluate(ctx);
        }
        return value;
    }

    protected Resource getResource(GroupTemplate gt, String name) {
        Map<String, String> resourceMap = gt.getConf().getResourceMap();
        String functionSuffix = resourceMap.get("functionSuffix");
        String functionRoot = resourceMap.get("functionRoot");
        String path = name.replace(".", "/");
        return gt.getResourceLoader().getResource(functionRoot + "/" + path + "." + functionSuffix);
    }
}

