/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.spi.mapper;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.internal.spi.mapper.MapperBase;
import com.jayway.jsonpath.spi.mapper.MappingException;
import java.math.BigDecimal;

public class NumberMapper
extends MapperBase {
    public NumberMapper() {
        this.register(Integer.class, Long.class);
        this.register(Double.class, Long.class);
        this.register(Float.class, Long.class);
        this.register(BigDecimal.class, Long.class);
        this.register(String.class, Long.class);
        this.register(Long.class, Integer.class);
        this.register(Double.class, Integer.class);
        this.register(Float.class, Integer.class);
        this.register(BigDecimal.class, Integer.class);
        this.register(String.class, Integer.class);
        this.register(Long.class, Double.class);
        this.register(Integer.class, Double.class);
        this.register(Float.class, Double.class);
        this.register(BigDecimal.class, Double.class);
        this.register(String.class, Double.class);
        this.register(Long.class, Float.class);
        this.register(Integer.class, Float.class);
        this.register(Double.class, Float.class);
        this.register(BigDecimal.class, Float.class);
        this.register(String.class, Float.class);
        this.register(Long.class, BigDecimal.class);
        this.register(Integer.class, BigDecimal.class);
        this.register(Double.class, BigDecimal.class);
        this.register(Float.class, BigDecimal.class);
        this.register(String.class, BigDecimal.class);
    }

    @Override
    public Object convert(Object src, Class<?> srcType, Class<?> targetType, Configuration conf) {
        this.assertValidConversion(src, srcType, targetType);
        if (src == null) {
            return null;
        }
        if (targetType.equals(Long.class)) {
            if (Integer.class.isAssignableFrom(srcType)) {
                return ((Integer)src).longValue();
            }
            if (Double.class.isAssignableFrom(srcType)) {
                return ((Double)src).longValue();
            }
            if (BigDecimal.class.isAssignableFrom(srcType)) {
                return ((BigDecimal)src).longValue();
            }
            if (Float.class.isAssignableFrom(srcType)) {
                return ((Float)src).longValue();
            }
            if (String.class.isAssignableFrom(srcType)) {
                return Long.parseLong(src.toString());
            }
        } else if (targetType.equals(Integer.class)) {
            if (Long.class.isAssignableFrom(srcType)) {
                return ((Long)src).intValue();
            }
            if (Double.class.isAssignableFrom(srcType)) {
                return ((Double)src).intValue();
            }
            if (BigDecimal.class.isAssignableFrom(srcType)) {
                return ((BigDecimal)src).intValue();
            }
            if (Float.class.isAssignableFrom(srcType)) {
                return ((Float)src).intValue();
            }
            if (String.class.isAssignableFrom(srcType)) {
                return Integer.parseInt(src.toString());
            }
        } else if (targetType.equals(Double.class)) {
            if (Long.class.isAssignableFrom(srcType)) {
                return ((Long)src).doubleValue();
            }
            if (Integer.class.isAssignableFrom(srcType)) {
                return ((Integer)src).doubleValue();
            }
            if (BigDecimal.class.isAssignableFrom(srcType)) {
                return ((BigDecimal)src).doubleValue();
            }
            if (Float.class.isAssignableFrom(srcType)) {
                return ((Float)src).doubleValue();
            }
            if (String.class.isAssignableFrom(srcType)) {
                return Double.parseDouble(src.toString());
            }
        } else if (targetType.equals(Float.class)) {
            if (Long.class.isAssignableFrom(srcType) && targetType.equals(Float.class)) {
                return Float.valueOf(((Long)src).floatValue());
            }
            if (Integer.class.isAssignableFrom(srcType) && targetType.equals(Float.class)) {
                return Float.valueOf(((Integer)src).floatValue());
            }
            if (BigDecimal.class.isAssignableFrom(srcType) && targetType.equals(Float.class)) {
                return Float.valueOf(((BigDecimal)src).floatValue());
            }
            if (Double.class.isAssignableFrom(srcType) && targetType.equals(Float.class)) {
                return Float.valueOf(((Double)src).floatValue());
            }
            if (String.class.isAssignableFrom(srcType) && targetType.equals(Float.class)) {
                return Float.valueOf(Float.parseFloat(src.toString()));
            }
        } else if (targetType.equals(BigDecimal.class)) {
            if (Long.class.isAssignableFrom(srcType) && targetType.equals(BigDecimal.class)) {
                return new BigDecimal(src.toString());
            }
            if (Integer.class.isAssignableFrom(srcType) && targetType.equals(BigDecimal.class)) {
                return new BigDecimal(src.toString());
            }
            if (Float.class.isAssignableFrom(srcType) && targetType.equals(BigDecimal.class)) {
                return new BigDecimal(src.toString());
            }
            if (Double.class.isAssignableFrom(srcType) && targetType.equals(BigDecimal.class)) {
                return new BigDecimal(src.toString());
            }
            if (String.class.isAssignableFrom(srcType) && targetType.equals(BigDecimal.class)) {
                return new BigDecimal(src.toString());
            }
        }
        throw new MappingException("Can not map: " + srcType.getName() + " to: " + targetType.getName());
    }
}

