/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.io;

import com.jfinal.template.io.Encoder;

public class Utf8Encoder
implements Encoder {
    public static final Utf8Encoder me = new Utf8Encoder();

    @Override
    public float maxBytesPerChar() {
        return 3.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int encode(char[] chars, int offset, int len, byte[] bytes) {
        int sl = offset + len;
        int dp = 0;
        int dlASCII = dp + Math.min(len, bytes.length);
        while (dp < dlASCII && chars[offset] < '\u0080') {
            bytes[dp++] = (byte)chars[offset++];
        }
        while (true) {
            int c;
            block12: {
                int uc;
                block11: {
                    block13: {
                        if (offset >= sl) {
                            return dp;
                        }
                        if ((c = chars[offset++]) < 128) {
                            bytes[dp++] = (byte)c;
                            continue;
                        }
                        if (c < 2048) {
                            bytes[dp++] = (byte)(0xC0 | c >> 6);
                            bytes[dp++] = (byte)(0x80 | c & 0x3F);
                            continue;
                        }
                        if (c < 55296 || c >= 57344) break block12;
                        int ip = offset - 1;
                        if (!Character.isHighSurrogate((char)c)) break block13;
                        if (sl - ip < 2) {
                            uc = -1;
                            break block11;
                        } else {
                            char d = chars[ip + 1];
                            if (Character.isLowSurrogate(d)) {
                                uc = Character.toCodePoint((char)c, d);
                                break block11;
                            } else {
                                bytes[dp++] = 63;
                                continue;
                            }
                        }
                    }
                    if (Character.isLowSurrogate((char)c)) {
                        bytes[dp++] = 63;
                        continue;
                    }
                    uc = c;
                }
                if (uc < 0) {
                    bytes[dp++] = 63;
                    continue;
                }
                bytes[dp++] = (byte)(0xF0 | uc >> 18);
                bytes[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                bytes[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                bytes[dp++] = (byte)(0x80 | uc & 0x3F);
                ++offset;
                continue;
            }
            bytes[dp++] = (byte)(0xE0 | c >> 12);
            bytes[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[dp++] = (byte)(0x80 | c & 0x3F);
        }
    }
}

