/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.jetty;

import com.jfinal.kit.FileKit;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.StrKit;
import com.jfinal.server.IServer;
import com.jfinal.server.jetty.JFinalClassLoader;
import com.jfinal.server.jetty.Scanner;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.session.FileSessionDataStoreFactory;
import org.eclipse.jetty.webapp.WebAppContext;

class JettyServer
implements IServer {
    protected String webAppDir;
    protected int port;
    protected String context;
    protected int scanIntervalSeconds;
    protected Server server;
    protected WebAppContext webApp;
    protected volatile boolean started = false;

    JettyServer(String webAppDir, int port, String context, int scanIntervalSeconds) {
        if (webAppDir == null) {
            throw new IllegalStateException("Invalid webAppDir of web server: " + webAppDir);
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port of web server: " + port);
        }
        if (StrKit.isBlank((String)context)) {
            throw new IllegalStateException("Invalid context of web server: " + context);
        }
        this.webAppDir = webAppDir;
        this.port = port;
        this.context = context;
        this.scanIntervalSeconds = scanIntervalSeconds;
    }

    public void start() {
        if (!this.started) {
            try {
                this.started = true;
                this.doStart();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                LogKit.error((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.started) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LogKit.error((String)e.getMessage(), (Throwable)e);
            }
            this.started = false;
        }
    }

    private void doStart() {
        if (!JettyServer.available(this.port)) {
            throw new IllegalStateException("port: " + this.port + " already in use!");
        }
        this.deleteSessionData();
        System.out.println("Starting JFinal " + this.getJFinalVersion());
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        this.webApp = new WebAppContext();
        this.webApp.getSystemClasspathPattern().add("sun.");
        this.webApp.getSystemClasspathPattern().add("com.sun.");
        this.webApp.getSystemClasspathPattern().add("org.apache.jasper.");
        this.webApp.getSystemClasspathPattern().add("org.apache.taglibs.");
        this.webApp.getSystemClasspathPattern().add("org.glassfish.jsp.");
        this.webApp.getSystemClasspathPattern().add("org.slf4j.");
        this.webApp.setThrowUnavailableOnStartupException(true);
        this.webApp.setContextPath(this.context);
        this.webApp.setResourceBase(this.webAppDir);
        this.webApp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.webApp.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        this.webApp.setMaxFormContentSize(0x10000000);
        this.persistSession(this.server);
        this.server.setHandler((Handler)this.webApp);
        this.server.setStopAtShutdown(true);
        this.server.setDumpAfterStart(false);
        this.server.setDumpBeforeStop(false);
        if (this.scanIntervalSeconds > 0) {
            this.changeClassLoader(this.webApp);
            Scanner scanner = new Scanner(PathKit.getRootClassPath(), this.scanIntervalSeconds){

                @Override
                public void onChange() {
                    try {
                        System.err.println("\nLoading changes ......");
                        JettyServer.this.webApp.stop();
                        JFinalClassLoader loader = new JFinalClassLoader(JettyServer.this.webApp, JettyServer.this.getClassPath());
                        JettyServer.this.webApp.setClassLoader((ClassLoader)((Object)loader));
                        JettyServer.this.webApp.start();
                        System.err.println("Loading complete (^_^)");
                    }
                    catch (Exception e) {
                        System.err.println("Error reconfiguring/restarting webapp after change in watched files");
                        LogKit.error((String)e.getMessage(), (Throwable)e);
                    }
                }
            };
            System.out.println("Starting scanner at interval of " + this.scanIntervalSeconds + " seconds");
            scanner.start();
        }
        try {
            System.out.println("Starting Jetty Server " + Server.getVersion() + " on port: " + this.port);
            this.server.start();
            System.out.println("Starting Complete. Welcome To The JFinal World (^_^)");
            this.server.join();
        }
        catch (Exception e) {
            LogKit.error((String)e.getMessage(), (Throwable)e);
            System.exit(100);
        }
    }

    private void changeClassLoader(WebAppContext webApp) {
        try {
            String classPath = this.getClassPath();
            JFinalClassLoader jfcl = new JFinalClassLoader(webApp, classPath);
            webApp.setClassLoader((ClassLoader)((Object)jfcl));
        }
        catch (IOException e) {
            LogKit.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private String getClassPath() {
        return System.getProperty("java.class.path");
    }

    private void deleteSessionData() {
        try {
            FileKit.delete((File)new File(this.getStoreDir()));
        }
        catch (Exception e) {
            LogKit.logNothing((Throwable)e);
        }
    }

    private String getStoreDir() {
        String storeDir = PathKit.getWebRootPath() + "/../../session_data" + this.context;
        if ("\\".equals(File.separator)) {
            storeDir = storeDir.replaceAll("/", "\\\\");
        }
        return storeDir;
    }

    private void persistSession(Server server) {
        String storeDir = this.getStoreDir();
        FileSessionDataStoreFactory fsdsf = new FileSessionDataStoreFactory();
        fsdsf.setStoreDir(new File(storeDir));
        server.addBean((Object)fsdsf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean available(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LogKit.logNothing((Throwable)e);
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    LogKit.logNothing((Throwable)e);
                }
            }
        }
        return false;
    }

    protected String getJFinalVersion() {
        try {
            Class<?> clazz = Class.forName("com.jfinal.core.Const");
            Field field = clazz.getField("JFINAL_VERSION");
            return (String)field.get(null);
        }
        catch (Exception e) {
            return "3.6";
        }
    }
}

