/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class Configuration {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String ROLE_FIELD = "role";
    private final String MASTER_HOST_FIELD = "master.host";
    private final String MASTER_PORT_FIELD = "master.port";
    private final String REDIS_HOST_FIELD = "redis.host";
    private final String REDIS_PORT_FIELD = "redis.port";
    private final String REDIS_PASSWD_FIELD = "redis.passwd";
    private final String MASTER_INSTANCE_NUM_FIELD = "master.instance.number";
    private final String DUPCHECKER_CLASS_FIELD = "dupchecker.class";
    private final String SCHEDULER_CLASS_FIELD = "scheduler.class";
    private final String DATASTORE_CLASS_FIELD = "datastore.class";
    private final String CRAWLER_REGISTRATION_CLASS_FIELD = "crawler.registration.class";
    private final String URL_BATCH_SIZE_FIELD = "url.batch.size";
    private final String URL_CHECK_INTERVAL_FIELD = "url.check.interval";
    private final String URL_FETCH_INTERVAL_FIELD = "url.fetch.interval";
    private final String EXECUTOR_INSTANCE_NUM_FIELD = "executor.instance.number";
    private final String PROXY_CHANGE_INTERVAL_FIELD = "proxy.change.interval";
    private final String DOMAIN_QUEUE_SIZE_FIELD = "domain.queue.size";
    private final String FILESTORE_PATH_FIELD = "file.store.path";
    private final String DOWNLOAD_INTERVAL_FIELD = "download.interval";
    private final String RETRY_TIMES_FIELD = "retry.times";
    private final String DEFAULT_ROLE = Role.SLAVE.toString();
    private final String DEFAULT_MASTER_HOST = "127.0.0.1";
    private final int DEFAULT_MASTER_PORT = 8080;
    private final String DEFAULT_REDIS_HOST = "127.0.0.1";
    private final int DEFAULT_REDIS_PORT = 6379;
    private final String DEFAULT_REDIS_PASSWD;
    private final int DEFAULT_MASTER_INSTANCE_NUM = 1;
    private final String DEFAULT_DUPCHECKER_CLASS = "RedisDupChecker";
    private final String DEFAULT_SCHEDULER_CLASS = "RedisScheduler";
    private final String DEFAULT_DATASTORE_CLASS = "RedisDatastore";
    private final String DEFAULT_CRAWLER_REGISTRATION_CLASS = "com.lab_440.tentacles.slave.registration.BaseRegistration";
    private final int DEFAULT_URL_BATCH_SIZE = 1;
    private final int DEFAULT_URL_CHECK_INTERVAL = 10;
    private final int DEFAULT_URL_FETCH_INTERVAL = 30;
    private final int DEFAULT_EXECUTOR_INSTANCE_NUM = 1;
    private final int DEFAULT_PROXY_CHANGE_INTERVAL = 600;
    private final int DEFAULT_DOMAIN_QUEUE_SIZE = 0;
    private final String DEFAULT_FILESTORE_PATH = "/tmp/tentacles/files";
    private final int DEFAULT_DOWNLOAD_INTERVAL = 100;
    private final int DEFAULT_RETRY_TIMES = 2;
    private Role role;
    private String masterHost;
    private int masterPort;
    private String redisHost;
    private int redisPort;
    private String redisPasswd;
    private int masterNum;
    private String dupCheckerClass;
    private String schedulerClass;
    private String dataStoreClass;
    private String crawlerRegistration;
    private int urlBatchSize;
    private int urlCheckInterval;
    private int urlFetchInterval;
    private int executorNum;
    private int proxyChangeInterval;
    private int domainQueueSize;
    private String fileStorePath;
    private int downloadInterval;
    private int retryTimes;

    public Configuration() {
        this.DEFAULT_REDIS_PASSWD = null;
        this.fromJsonObject(new JsonObject());
    }

    public Configuration(JsonObject jObj) {
        this.DEFAULT_REDIS_PASSWD = null;
        this.fromJsonObject(jObj);
    }

    public Configuration(String configPath) {
        this.DEFAULT_REDIS_PASSWD = null;
        try {
            File configFile = new File(configPath);
            Properties prop = this.loadConfigs(configFile);
            String sRole = prop.getProperty("role", this.DEFAULT_ROLE);
            this.role = sRole.toUpperCase().equals(Role.MASTER.toString()) ? Role.MASTER : Role.SLAVE;
            this.masterHost = prop.getProperty("master.host", "127.0.0.1");
            this.masterPort = this.getIntProperty(prop, "master.port", 8080);
            this.redisHost = prop.getProperty("redis.host", "127.0.0.1");
            this.redisPort = this.getIntProperty(prop, "redis.port", 6379);
            this.redisPasswd = prop.getProperty("redis.passwd", this.DEFAULT_REDIS_PASSWD);
            this.masterNum = this.getIntProperty(prop, "master.instance.number", 1);
            this.dupCheckerClass = prop.getProperty("dupchecker.class", "RedisDupChecker");
            this.schedulerClass = prop.getProperty("scheduler.class", "RedisScheduler");
            this.dataStoreClass = prop.getProperty("datastore.class", "RedisDatastore");
            this.crawlerRegistration = prop.getProperty("crawler.registration.class", "com.lab_440.tentacles.slave.registration.BaseRegistration");
            this.urlBatchSize = this.getIntProperty(prop, "url.batch.size", 1);
            this.urlCheckInterval = this.getIntProperty(prop, "url.check.interval", 10);
            this.urlFetchInterval = this.getIntProperty(prop, "url.fetch.interval", 30);
            this.executorNum = this.getIntProperty(prop, "executor.instance.number", 1);
            this.proxyChangeInterval = this.getIntProperty(prop, "proxy.change.interval", 600);
            this.domainQueueSize = this.getIntProperty(prop, "domain.queue.size", 0);
            this.fileStorePath = prop.getProperty("file.store.path", "/tmp/tentacles/files");
            this.downloadInterval = this.getIntProperty(prop, "download.interval", 100);
            this.retryTimes = this.getIntProperty(prop, "retry.times", 2);
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Failed to load configurations! {}", new Object[]{ioe.getMessage()});
            System.exit(1);
        }
    }

    public JsonObject toJsonObject() {
        return new JsonObject().put("role", (Enum)this.role).put("master.host", this.masterHost).put("master.port", Integer.valueOf(this.masterPort)).put("redis.host", this.redisHost).put("redis.port", Integer.valueOf(this.redisPort)).put("redis.passwd", this.redisPasswd).put("master.instance.number", Integer.valueOf(this.masterNum)).put("dupchecker.class", this.dupCheckerClass).put("scheduler.class", this.schedulerClass).put("datastore.class", this.dataStoreClass).put("crawler.registration.class", this.crawlerRegistration).put("url.batch.size", Integer.valueOf(this.urlBatchSize)).put("url.check.interval", Integer.valueOf(this.urlCheckInterval)).put("url.fetch.interval", Integer.valueOf(this.urlFetchInterval)).put("executor.instance.number", Integer.valueOf(this.executorNum)).put("proxy.change.interval", Integer.valueOf(this.proxyChangeInterval)).put("domain.queue.size", Integer.valueOf(this.domainQueueSize)).put("file.store.path", this.fileStorePath).put("download.interval", Integer.valueOf(this.downloadInterval)).put("retry.times", Integer.valueOf(this.retryTimes));
    }

    public Configuration fromJsonObject(JsonObject jObj) {
        String roleStr = jObj.getString("role", Role.SLAVE.toString());
        this.role = roleStr.equals(Role.MASTER.toString()) ? Role.MASTER : Role.SLAVE;
        this.masterHost = jObj.getString("master.host", "127.0.0.1");
        this.masterPort = jObj.getInteger("master.port", Integer.valueOf(8080));
        this.redisHost = jObj.getString("redis.host", "127.0.0.1");
        this.redisPort = jObj.getInteger("redis.port", Integer.valueOf(6379));
        this.redisPasswd = jObj.getString("redis.passwd", this.DEFAULT_REDIS_PASSWD);
        this.masterNum = jObj.getInteger("master.instance.number", Integer.valueOf(1));
        this.dupCheckerClass = jObj.getString("dupchecker.class", "RedisDupChecker");
        this.schedulerClass = jObj.getString("scheduler.class", "RedisScheduler");
        this.dataStoreClass = jObj.getString("datastore.class", "RedisDatastore");
        this.crawlerRegistration = jObj.getString("crawler.registration.class", "com.lab_440.tentacles.slave.registration.BaseRegistration");
        this.urlBatchSize = jObj.getInteger("url.batch.size", Integer.valueOf(1));
        this.urlCheckInterval = jObj.getInteger("url.check.interval", Integer.valueOf(10));
        this.urlFetchInterval = jObj.getInteger("url.fetch.interval", Integer.valueOf(30));
        this.executorNum = jObj.getInteger("executor.instance.number", Integer.valueOf(1));
        this.proxyChangeInterval = jObj.getInteger("proxy.change.interval", Integer.valueOf(600));
        this.domainQueueSize = jObj.getInteger("domain.queue.size", Integer.valueOf(0));
        this.fileStorePath = jObj.getString("file.store.path", "/tmp/tentacles/files");
        this.downloadInterval = jObj.getInteger("download.interval", Integer.valueOf(100));
        this.retryTimes = jObj.getInteger("retry.times", Integer.valueOf(2));
        return this;
    }

    public Role getRole() {
        return this.role;
    }

    public String getMasterHost() {
        return this.masterHost;
    }

    public int getMasterPort() {
        return this.masterPort;
    }

    public int getMasterNum() {
        return this.masterNum;
    }

    public String getRedisHost() {
        return this.redisHost;
    }

    public int getRedisPort() {
        return this.redisPort;
    }

    public String getRedisPasswd() {
        return this.redisPasswd;
    }

    public String getDupCheckerClass() {
        return this.dupCheckerClass;
    }

    public String getSchedulerClass() {
        return this.schedulerClass;
    }

    public String getDataStoreClass() {
        return this.dataStoreClass;
    }

    public String getCrawlerRegistration() {
        return this.crawlerRegistration;
    }

    public int getUrlBatchSize() {
        return this.urlBatchSize;
    }

    public int getUrlCheckInterval() {
        return this.urlCheckInterval;
    }

    public int getUrlFetchInterval() {
        return this.urlFetchInterval;
    }

    public int getExecutorNum() {
        return this.executorNum;
    }

    public int getProxyChangeInterval() {
        return this.proxyChangeInterval;
    }

    public int getDomainQueueSize() {
        return this.domainQueueSize;
    }

    public String getFileStorePath() {
        return this.fileStorePath;
    }

    public int getDownloadInterval() {
        return this.downloadInterval;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    private int getIntProperty(Properties prop, String field, int defaultValue) {
        String strVal = prop.getProperty(field);
        if (strVal == null || strVal.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(strVal);
    }

    private Properties loadConfigs(File configFile) throws IOException {
        Properties prop = new Properties();
        prop.load(new FileReader(configFile));
        return prop;
    }

    public static enum Role {
        MASTER,
        SLAVE;

    }
}

