/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.common;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class RemoteCall {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String CHECK_MASTER_STATUS_URI = "/check_master_status";
    public static final String FETCH_URLS_URI = "/fetch_urls";
    public static final String STORE_ITEMS_URI = "/store_items";
    public static final String FOLLOW_LINKS_URI = "/follow_links";
    public static final String REPLY_URI = "/reply";
    private String host;
    private int port;
    private HttpClient hc;

    public RemoteCall(Vertx vertx, String host, int port) {
        this.host = host;
        this.port = port;
        this.hc = vertx.createHttpClient();
    }

    public void checkMasterStatus(Handler<Buffer> onSucc, Handler<Throwable> onError) {
        this.get(CHECK_MASTER_STATUS_URI, onSucc, onError);
    }

    public void fetchUrls(JsonObject domainBS, Handler<Buffer> onSucc, Handler<Throwable> onError) {
        this.post(FETCH_URLS_URI, domainBS.encode(), onSucc, onError);
    }

    public void storeItems(JsonArray items, Handler<Buffer> onSucc, Handler<Throwable> onError) {
        this.post(STORE_ITEMS_URI, items.encode(), onSucc, onError);
    }

    public void followLinks(JsonArray urls, Handler<Buffer> onSucc, Handler<Throwable> onError) {
        this.post(FOLLOW_LINKS_URI, urls.encode(), onSucc, onError);
    }

    public void reply(JsonObject jObj, Handler<Buffer> onSucc, Handler<Throwable> onError) {
        this.post(REPLY_URI, jObj.encode(), onSucc, onError);
    }

    public void get(String uri, Handler<Buffer> onSucc, Handler<Throwable> onError) {
        HttpClientRequest req = this.hc.request(HttpMethod.GET, this.port, this.host, uri, resp -> {
            if (resp.statusCode() != 200) {
                onError.handle((Object)new RuntimeException("Wrong status code " + resp.statusCode()));
            }
            resp.bodyHandler(onSucc);
            resp.exceptionHandler(onError);
        });
        req.exceptionHandler(onError);
        req.end();
    }

    public void post(String uri, String data, Handler<Buffer> onSucc, Handler<Throwable> onError) {
        HttpClientRequest req = this.hc.request(HttpMethod.POST, this.port, this.host, uri, resp -> {
            if (resp.statusCode() != 200) {
                onError.handle((Object)new RuntimeException("Wrong status code " + resp.statusCode()));
            }
            resp.bodyHandler(onSucc);
            resp.exceptionHandler(onError);
        });
        req.exceptionHandler(onError);
        req.end(data);
    }
}

