/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.common.item;

import com.lab_440.tentacles.common.item.AbstractItem;
import io.vertx.core.json.JsonObject;

public class RequestItem
extends AbstractItem {
    private final String URL_FIELD = "url";
    private final String DOMAIN_FIELD = "domain";
    private final String FORCE_REPEAT_FIELD = "is_repeat";
    private final String RETRIED_FIELD = "retried";
    private String url;
    private String domain;
    private boolean forceRepeat = false;
    private int retried;

    public RequestItem(String url) {
        String[] segs = url.split("/");
        this.domain = segs.length < 3 ? null : segs[2];
    }

    public RequestItem() {
    }

    @Override
    public String identity() {
        return this.url;
    }

    @Override
    public JsonObject toJsonObject() {
        JsonObject jObj = new JsonObject();
        if (this.url != null) {
            jObj.put("url", this.url);
        }
        if (this.domain != null) {
            jObj.put("domain", this.domain);
        }
        if (this.forceRepeat) {
            jObj.put("is_repeat", Boolean.valueOf(true));
        }
        if (this.retried > 0) {
            jObj.put("retried", Integer.valueOf(this.retried));
        }
        return jObj;
    }

    @Override
    public void fromJsonObject(JsonObject jObj) {
        this.url = jObj.getString("url", null);
        this.domain = jObj.getString("domain", null);
        if (this.domain == null) {
            String[] segs = this.url.split("/");
            this.domain = segs.length < 3 ? null : segs[2];
        }
        this.forceRepeat = jObj.getBoolean("is_repeat", Boolean.valueOf(false));
        this.retried = jObj.getInteger("retried", Integer.valueOf(0));
    }

    public String getUrl() {
        return this.url;
    }

    public RequestItem setUrl(String url) {
        this.url = url;
        return this;
    }

    public boolean getForceRepeat() {
        return this.forceRepeat;
    }

    public RequestItem setForceRepeat(boolean forceRepeat) {
        this.forceRepeat = forceRepeat;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public RequestItem setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public int getRetried() {
        return this.retried;
    }

    public RequestItem setRetried(int retried) {
        this.retried = retried;
        return this;
    }
}

