/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.master.datastore;

import com.lab_440.tentacles.common.Configuration;
import com.lab_440.tentacles.master.datastore.IDatastore;
import com.lab_440.tentacles.master.scheduler.RedisPool;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisDatastore
implements IDatastore {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DATASTORE_LIST_KEY = "tentacles_datastore_key";
    private RedisPool pool;

    public RedisDatastore(Configuration conf) {
        String host = conf.getRedisHost();
        int port = conf.getRedisPort();
        String passwd = conf.getRedisPasswd();
        this.pool = RedisPool.getOrCreate(host, port, passwd);
    }

    @Override
    public boolean store(JsonObject item) {
        boolean result;
        try (Jedis jedis = this.pool.getResource();){
            jedis.rpush("tentacles_datastore_key", new String[]{item.encode()});
            result = true;
        }
        catch (Exception e) {
            result = false;
            this.logger.error((Object)e.getMessage());
        }
        return result;
    }
}

