/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.master.scheduler;

import com.lab_440.tentacles.common.Configuration;
import com.lab_440.tentacles.common.item.RequestItem;
import com.lab_440.tentacles.master.scheduler.IDupChecker;
import com.lab_440.tentacles.master.scheduler.IScheduler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class QueueScheduler
implements IScheduler<RequestItem> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IDupChecker<RequestItem> dupChecker;
    private Map<String, Queue<RequestItem>> reqQueue = new HashMap<String, Queue<RequestItem>>();
    private Set<String> allDomains = new HashSet<String>();

    public QueueScheduler(Configuration conf) {
    }

    @Override
    public void setDupChecker(IDupChecker<RequestItem> dupChecker) {
        this.dupChecker = dupChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String domain, RequestItem item) {
        try {
            if (!item.getForceRepeat() && this.dupChecker.isDuplicated(item)) {
                return false;
            }
            QueueScheduler queueScheduler = this;
            synchronized (queueScheduler) {
                if (!this.reqQueue.containsKey(domain)) {
                    this.reqQueue.put(domain, new ArrayDeque());
                    this.allDomains.add(domain);
                }
                this.reqQueue.get(domain).add(item);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to add item: {}", new Object[]{e.getMessage()});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestItem poll(String domain) {
        QueueScheduler queueScheduler = this;
        synchronized (queueScheduler) {
            Queue<RequestItem> dmQueue = this.reqQueue.get(domain);
            if (dmQueue != null && !dmQueue.isEmpty()) {
                return dmQueue.poll();
            }
            this.allDomains.remove(domain);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RequestItem> pollBatch(Set<String> exclude, int cnt) {
        ArrayList<RequestItem> itemList = new ArrayList<RequestItem>();
        HashSet<String> domainSet = new HashSet<String>(this.allDomains);
        domainSet.removeAll(exclude);
        if (domainSet.size() == 0) {
            return itemList;
        }
        while (domainSet.size() > 0) {
            Iterator domItr = domainSet.iterator();
            while (domItr.hasNext()) {
                QueueScheduler queueScheduler = this;
                synchronized (queueScheduler) {
                    String domain = (String)domItr.next();
                    Queue<RequestItem> dmQueue = this.reqQueue.get(domain);
                    if (dmQueue == null || dmQueue.isEmpty()) {
                        this.allDomains.remove(domain);
                        domItr.remove();
                    } else {
                        itemList.add(dmQueue.poll());
                        if (--cnt == 0) {
                            break;
                        }
                    }
                }
            }
            if (cnt != 0) continue;
            break;
        }
        return itemList;
    }
}

