/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.master.scheduler;

import com.lab_440.tentacles.common.Configuration;
import com.lab_440.tentacles.common.IDGenerator;
import com.lab_440.tentacles.common.item.AbstractItem;
import com.lab_440.tentacles.master.scheduler.IDupChecker;
import com.lab_440.tentacles.master.scheduler.RedisPool;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisDupChecker
implements IDupChecker<AbstractItem> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DUP_SET_KEY = "crawler_dup_checker_key";
    private RedisPool pool;

    public RedisDupChecker(Configuration conf) {
        String host = conf.getRedisHost();
        int port = conf.getRedisPort();
        String passwd = conf.getRedisPasswd();
        this.pool = RedisPool.getOrCreate(host, port, passwd);
    }

    @Override
    public boolean isDuplicated(AbstractItem item) {
        boolean result;
        String id = IDGenerator.generateID(item.identity());
        try (Jedis jedis = this.pool.getResource();){
            result = 0L == jedis.sadd("crawler_dup_checker_key", new String[]{id});
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            throw e;
        }
        return result;
    }
}

