/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.master.scheduler;

import com.lab_440.tentacles.common.Configuration;
import com.lab_440.tentacles.common.item.RequestItem;
import com.lab_440.tentacles.master.scheduler.IDupChecker;
import com.lab_440.tentacles.master.scheduler.IScheduler;
import com.lab_440.tentacles.master.scheduler.RedisPool;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import redis.clients.jedis.Jedis;

public class RedisScheduler
implements IScheduler<RequestItem> {
    private final String QUEUE_KEY_PREFIX = "crawler_scheduler_queue:";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IDupChecker<RequestItem> dupChecker;
    private RedisPool pool;
    private Set<String> allDomains;

    public RedisScheduler(Configuration conf) {
        String host = conf.getRedisHost();
        int port = conf.getRedisPort();
        String passwd = conf.getRedisPasswd();
        this.pool = RedisPool.getOrCreate(host, port, passwd);
        this.allDomains = new HashSet<String>();
    }

    @Override
    public void setDupChecker(IDupChecker<RequestItem> dupChecker) {
        this.dupChecker = dupChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String domain, RequestItem item) {
        boolean result;
        if (this.dupChecker.isDuplicated(item)) {
            return false;
        }
        try (Jedis jedis = this.pool.getResource();){
            String domainKey = "crawler_scheduler_queue:" + domain;
            RedisScheduler redisScheduler = this;
            synchronized (redisScheduler) {
                jedis.rpush(domainKey, new String[]{RequestItem.encode(item)});
                this.allDomains.add(domain);
            }
            result = true;
        }
        catch (Exception e) {
            result = false;
            this.logger.error((Object)"Failed to add item: {}", new Object[]{e.getMessage()});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestItem poll(String domain) {
        RequestItem retItem;
        try (Jedis jedis = this.pool.getResource();){
            RedisScheduler redisScheduler = this;
            synchronized (redisScheduler) {
                String domainKey = "crawler_scheduler_queue:" + domain;
                if (jedis.llen(domainKey) > 0L) {
                    String s = jedis.lpop(domainKey);
                    retItem = new RequestItem();
                    RequestItem.decode(s, retItem);
                } else {
                    this.allDomains.remove(domain);
                    retItem = null;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            retItem = null;
        }
        return retItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RequestItem> pollBatch(Set<String> exclude, int cnt) {
        ArrayList<RequestItem> itemList = new ArrayList<RequestItem>();
        HashSet<String> domainSet = new HashSet<String>(this.allDomains);
        domainSet.removeAll(exclude);
        if (domainSet.size() == 0) {
            return itemList;
        }
        try (Jedis jedis = this.pool.getResource();){
            while (domainSet.size() > 0) {
                Iterator domItr = domainSet.iterator();
                while (domItr.hasNext()) {
                    RedisScheduler redisScheduler = this;
                    synchronized (redisScheduler) {
                        String domain = (String)domItr.next();
                        String domainKey = "crawler_scheduler_queue:" + domain;
                        if (jedis.llen(domainKey) > 0L) {
                            String s = jedis.lpop(domainKey);
                            RequestItem retItem = new RequestItem();
                            RequestItem.decode(s, retItem);
                            itemList.add(retItem);
                            --cnt;
                        } else {
                            this.allDomains.remove(domain);
                            domainSet.remove(domain);
                        }
                    }
                    if (cnt != 0) continue;
                }
                if (cnt != 0) continue;
                break;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        return itemList;
    }
}

