/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.slave;

import com.lab_440.tentacles.common.Configuration;
import com.lab_440.tentacles.common.Register;
import com.lab_440.tentacles.common.item.RequestItem;
import com.lab_440.tentacles.slave.Planner;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayDeque;
import java.util.Queue;

public class DomainPlanner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Planner planner;
    private Vertx vertx;
    private EventBus eb;
    private String domain;
    private int queueSize;
    private Queue<RequestItem> highProiQueue;
    private Queue<RequestItem> requestQueue;
    private Queue<RequestItem> waitQueue;
    private Status status;
    private int downloadInterval;
    private long downloadTimerId;
    private long stopTimerId;

    public DomainPlanner(Planner planner, String domain, Configuration conf) {
        this.planner = planner;
        this.domain = domain;
        this.vertx = planner.getVertx();
        this.eb = this.vertx.eventBus();
        this.queueSize = conf.getDomainQueueSize();
        this.highProiQueue = new ArrayDeque<RequestItem>();
        this.requestQueue = new ArrayDeque<RequestItem>();
        this.waitQueue = new ArrayDeque<RequestItem>();
        this.downloadInterval = Register.getInstance().getInterval(domain);
        if (this.downloadInterval == 0) {
            this.downloadInterval = conf.getDownloadInterval();
        }
        this.status = Status.PAUSED;
    }

    public void schedule(RequestItem request, boolean highProi) {
        if (highProi) {
            this.highProiQueue.add(request);
            this.resume();
        } else {
            if (this.queueSize > 0 && this.queueSize == this.requestQueue.size()) {
                this.planner.pause(this.domain);
                this.waitQueue.add(request);
                return;
            }
            this.requestQueue.add(request);
            if (this.status == Status.TIMEWAIT) {
                this.status = Status.PAUSED;
            }
        }
    }

    public void pause() {
        this.vertx.cancelTimer(this.downloadTimerId);
        this.downloadTimerId = 0L;
        if (this.status == Status.RUNNING) {
            this.status = Status.PAUSED;
        }
    }

    public void resume() {
        if (this.status == Status.RUNNING) {
            return;
        }
        this.status = Status.RUNNING;
        this.vertx.cancelTimer(this.stopTimerId);
        this.stopTimerId = 0L;
        if (this.downloadTimerId == 0L) {
            this.downloadTimerId = this.vertx.setPeriodic((long)this.downloadInterval, id -> this.process());
        }
        this.process();
    }

    private void process() {
        if (!this.highProiQueue.isEmpty()) {
            this.eb.send("executor.url.listener", (Object)this.highProiQueue.poll());
        } else if (!this.requestQueue.isEmpty()) {
            this.eb.send("executor.url.listener", (Object)this.requestQueue.poll());
        } else if (!this.waitQueue.isEmpty()) {
            this.eb.send("executor.url.listener", (Object)this.waitQueue.poll());
            while (!this.waitQueue.isEmpty()) {
                this.requestQueue.add(this.waitQueue.poll());
            }
            this.planner.resume(this.domain);
        } else if (this.stopTimerId == 0L) {
            this.planner.resume(this.domain);
            if (this.requestQueue.isEmpty()) {
                this.status = Status.TIMEWAIT;
                this.stopTimerId = this.vertx.setTimer(120000L, id -> {
                    if (this.status == Status.TIMEWAIT) {
                        this.planner.recycleDomainSchedule(this.domain);
                    }
                });
            }
        }
    }

    public static enum Status {
        RUNNING,
        PAUSED,
        TIMEWAIT;

    }
}

