/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.slave;

import com.lab_440.tentacles.common.Configuration;
import com.lab_440.tentacles.common.IDGenerator;
import com.lab_440.tentacles.common.ProcessStatus;
import com.lab_440.tentacles.common.Register;
import com.lab_440.tentacles.common.item.AbstractItem;
import com.lab_440.tentacles.common.item.RequestItem;
import com.lab_440.tentacles.common.regex.ContentTypeMatcher;
import com.lab_440.tentacles.slave.AsyncFileStore;
import com.lab_440.tentacles.slave.Executor;
import com.lab_440.tentacles.slave.downloader.IDownloader;
import com.lab_440.tentacles.slave.downloader.IProxiable;
import com.lab_440.tentacles.slave.parser.IParser;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.streams.ReadStream;
import java.util.ArrayList;
import java.util.List;

public class Downloadable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Executor executor;
    private RequestItem request;
    private String url;
    private String domain;
    private IDownloader downloader;
    private IParser parser;
    private Type type;
    private List<String> followUrls;
    private List<AbstractItem> items;
    private int retryTimes;
    private ProcessStatus status;

    public Downloadable(Executor executor, RequestItem request) {
        this.executor = executor;
        this.request = request;
        this.url = request.getUrl();
        this.domain = request.getDomain();
        this.downloader = Register.getInstance().getDownloader(this.domain);
        this.parser = Register.getInstance().getParser(this.domain);
        this.followUrls = new ArrayList<String>();
        this.items = new ArrayList<AbstractItem>();
        this.retryTimes = executor.getConf().getRetryTimes();
        this.status = null;
    }

    public String getFilename() {
        String[] parts = this.url.split("/");
        if (parts.length == 0) {
            return IDGenerator.generateRandom();
        }
        return parts[parts.length - 1];
    }

    public void process(String processUrl) {
        try {
            this.downloader.get(processUrl, (Handler<HttpClientResponse>)((Handler)resp -> {
                switch (resp.statusCode()) {
                    case 301: 
                    case 302: 
                    case 303: {
                        this.processRedirection((HttpClientResponse)resp, processUrl);
                        break;
                    }
                    case 200: {
                        this.status = ProcessStatus.OK;
                        String contentType = resp.getHeader("Content-Type");
                        this.type = ContentTypeMatcher.match(contentType);
                        if (this.type == Type.IMAGE || this.type == Type.AUDIO) {
                            this.processBinary((HttpClientResponse)resp);
                            break;
                        }
                        if (this.type != Type.TEXT) break;
                        this.processText((HttpClientResponse)resp);
                        break;
                    }
                    default: {
                        this.status = ProcessStatus.NOT_RETURN;
                        this.processResult();
                    }
                }
                resp.exceptionHandler(err -> {
                    this.status = ProcessStatus.NOT_RETURN;
                    this.logger.error((Object)"Exception happened when downloading {}: {}", new Object[]{this.url, err.getMessage()});
                    this.processResult();
                });
            }));
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to download {}: {}", new Object[]{this.url, e.getMessage()});
            this.processResult();
        }
    }

    private void processText(HttpClientResponse resp) {
        resp.bodyHandler(buffer -> {
            try {
                this.parser.parse(this.url, buffer.toString());
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to parse {}: {}", new Object[]{this.url, e.getMessage()});
            }
            finally {
                this.processResult();
            }
        });
    }

    private void processBinary(HttpClientResponse resp) {
        Vertx vertx = this.executor.getVertx();
        Configuration conf = new Configuration(vertx.getOrCreateContext().config());
        String filePath = conf.getFileStorePath() + "/" + (Object)((Object)this.type) + "/" + this.getFilename();
        AsyncFileStore.asyncStore(vertx, (ReadStream<Buffer>)resp, filePath, (Handler<Void>)((Handler)res -> {
            this.processResult();
            this.logger.info((Object)"Successfully download {} file: {}", new Object[]{this.type.toString(), this.url});
        }));
    }

    private void processRedirection(HttpClientResponse resp, String url) {
        this.status = ProcessStatus.REDIRECT;
        String followUrl = resp.getHeader("Location");
        if (followUrl == null || followUrl.isEmpty() || followUrl.equals(url)) {
            this.logger.error((Object)"Failed to download {}, because redirection to invalid url", new Object[]{url});
        } else {
            this.url = followUrl;
            this.process(followUrl);
        }
    }

    private void processResult() {
        ProcessStatus parserStatus = this.parser.getStatus();
        this.status = parserStatus != null ? parserStatus : this.status;
        this.logger.info((Object)("Processing " + this.url + "(" + (Object)((Object)this.status) + ")"));
        if (this.status == ProcessStatus.OK) {
            this.items = this.parser.getItems();
            this.followUrls = this.parser.getFollowUrls();
            this.reply();
        } else if (this.status == ProcessStatus.BLOCKED) {
            this.changeProxy();
            this.process(this.url);
        } else if (this.status == ProcessStatus.NOT_RETURN) {
            this.retry();
        }
        this.storeItems();
        this.followLinks();
    }

    private void changeProxy() {
        if (this.downloader instanceof IProxiable) {
            ((IProxiable)((Object)this.downloader)).changeProxy();
        }
    }

    private void retry() {
        int retried = this.request.getRetried();
        if (retried < this.retryTimes) {
            this.request.setRetried(retried + 1);
            EventBus eb = this.executor.getEventBus();
            eb.send("retry.url.listener", (Object)this.request);
        } else {
            this.logger.error((Object)"Failed to download {} after {} retries!", new Object[]{this.url, this.retryTimes});
        }
    }

    private void storeItems() {
        if (this.items.size() == 0) {
            return;
        }
        this.executor.storeItems(this.items);
    }

    private void followLinks() {
        if (this.followUrls.size() == 0) {
            return;
        }
        this.executor.followLinks(this.followUrls);
    }

    private void reply() {
        this.executor.reply(this.url, this.status);
    }

    public static enum Type {
        TEXT,
        IMAGE,
        AUDIO;

    }
}

