/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.slave;

import com.lab_440.tentacles.common.Configuration;
import com.lab_440.tentacles.common.IDGenerator;
import com.lab_440.tentacles.common.ProcessStatus;
import com.lab_440.tentacles.common.RemoteCall;
import com.lab_440.tentacles.common.item.AbstractItem;
import com.lab_440.tentacles.common.item.RequestItem;
import com.lab_440.tentacles.slave.Downloadable;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.List;

public class Executor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Vertx vertx;
    private EventBus eb;
    private Configuration conf;
    private RemoteCall rcInstance;

    public Executor(Vertx vertx, JsonObject jsonConf) throws Exception {
        this.vertx = vertx;
        this.eb = vertx.eventBus();
        this.conf = new Configuration(jsonConf);
        this.rcInstance = new RemoteCall(vertx, this.conf.getMasterHost(), this.conf.getMasterPort());
    }

    public void run() {
        this.eb.consumer("executor.url.listener", request -> {
            RequestItem requestItem = (RequestItem)request.body();
            Downloadable dlb = new Downloadable(this, requestItem);
            dlb.process(requestItem.getUrl());
        });
    }

    public void storeItems(List<AbstractItem> items) {
        JsonArray jArr = new JsonArray();
        for (AbstractItem item : items) {
            String id = IDGenerator.generateID(item.identity());
            JsonObject itemObj = item.toJsonObject();
            jArr.add(itemObj.put("ITEM_ID", id));
        }
        this.rcInstance.storeItems(jArr, (Handler<Buffer>)((Handler)resp -> {
            JsonObject msg = new JsonObject(resp.toString());
            if (!msg.getString("status").equals("OK")) {
                this.logger.error((Object)("Failed to store items: " + msg));
            }
        }), (Handler<Throwable>)((Handler)err -> this.logger.error((Object)"Failed to call storeItems service")));
    }

    public void followLinks(List<String> urls) {
        JsonArray jArr = new JsonArray();
        for (String url : urls) {
            JsonObject jObj = new JsonObject().put("url", url);
            jArr.add(jObj);
        }
        this.rcInstance.followLinks(jArr, (Handler<Buffer>)((Handler)resp -> this.logger.info((Object)("Follow links: " + jArr.encode()))), (Handler<Throwable>)((Handler)err -> this.logger.error((Object)("Failed to follow links: " + jArr.encode()))));
    }

    public void reply(String url, ProcessStatus status) {
        JsonObject jObj = new JsonObject().put("url", url).put("status", (Enum)status);
        this.rcInstance.reply(jObj, (Handler<Buffer>)((Handler)resp -> {
            if (!resp.toString().equals("OK")) {
                this.logger.error((Object)("Reply with abnormal status: " + jObj.encode()));
            }
        }), (Handler<Throwable>)((Handler)err -> this.logger.error((Object)("Failed to reply to master: " + jObj.encode()))));
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public EventBus getEventBus() {
        return this.eb;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

