/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.slave;

import com.lab_440.tentacles.common.Configuration;
import com.lab_440.tentacles.common.Register;
import com.lab_440.tentacles.common.RemoteCall;
import com.lab_440.tentacles.common.item.RequestItem;
import com.lab_440.tentacles.slave.DomainPlanner;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Planner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Vertx vertx;
    private EventBus eb;
    private Configuration conf;
    private RemoteCall rcInstance;
    private Map<String, DomainPlanner> schedulerMap;
    private Set<String> pauseSet;
    private long fetchUrlTimerId;

    public Planner(Vertx vertx, JsonObject jsonConf) throws Exception {
        this.vertx = vertx;
        this.eb = vertx.eventBus();
        this.conf = new Configuration(jsonConf);
        this.rcInstance = new RemoteCall(vertx, this.conf.getMasterHost(), this.conf.getMasterPort());
        this.schedulerMap = new HashMap<String, DomainPlanner>();
        this.pauseSet = new HashSet<String>();
    }

    public void run() {
        this.eb.consumer("retry.url.listener", request -> this.scheduleOne((RequestItem)request.body(), true));
        int fetchInterval = this.conf.getUrlFetchInterval();
        if (fetchInterval > 0) {
            this.fetchUrlTimerId = this.vertx.setPeriodic((long)(fetchInterval * 1000), id -> this.runloop());
        }
        this.runloop();
    }

    private void runloop() {
        int defaultBS = this.conf.getUrlBatchSize();
        Register register = Register.getInstance();
        JsonObject domainBS = new JsonObject();
        domainBS.put("default.domain", Integer.valueOf(defaultBS));
        for (String domain : this.schedulerMap.keySet()) {
            if (this.pauseSet.contains(domain)) continue;
            int bs = register.getUrlBS(domain);
            if (bs == 0) {
                bs = defaultBS;
            }
            domainBS.put(domain, Integer.valueOf(bs));
        }
        this.rcInstance.fetchUrls(domainBS, (Handler<Buffer>)((Handler)respBody -> {
            JsonArray jsonArr = new JsonArray(respBody.toString());
            if (jsonArr.size() == 0) {
                this.logger.warn((Object)"Got no urls, will check later");
                this.schedLater();
            } else {
                this.scheduleAll(jsonArr);
            }
        }), (Handler<Throwable>)((Handler)err -> {
            this.logger.error((Object)"Failed to fetch urls from master! {}", new Object[]{err.getMessage()});
            this.schedLater();
        }));
    }

    private void schedLater() {
        int interval = this.conf.getUrlCheckInterval();
        if (interval > 0) {
            this.vertx.cancelTimer(this.fetchUrlTimerId);
            this.vertx.setTimer((long)(interval * 1000), id -> this.run());
        }
    }

    private void scheduleAll(JsonArray requests) {
        for (JsonObject jObj : requests) {
            RequestItem request = new RequestItem();
            request.fromJsonObject(jObj);
            this.scheduleOne(request, false);
        }
        for (String key : this.schedulerMap.keySet()) {
            if (this.pauseSet.contains(key)) continue;
            this.resume(key);
        }
    }

    private void scheduleOne(RequestItem request, boolean highProi) {
        String domain = request.getDomain();
        if (domain == null) {
            return;
        }
        if (!this.schedulerMap.containsKey(domain)) {
            this.schedulerMap.put(domain, new DomainPlanner(this, domain, this.conf));
        }
        this.schedulerMap.get(domain).schedule(request, highProi);
    }

    public void resume(String domain) {
        this.schedulerMap.get(domain).resume();
        if (this.pauseSet.contains(domain)) {
            this.pauseSet.remove(domain);
        }
    }

    public void pause(String domain) {
        this.schedulerMap.get(domain).pause();
        this.pauseSet.add(domain);
    }

    public void recycleDomainSchedule(String domain) {
        this.schedulerMap.remove(domain);
    }

    public Vertx getVertx() {
        return this.vertx;
    }
}

