/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.slave;

import com.lab_440.tentacles.common.AbstractRunner;
import com.lab_440.tentacles.common.Configuration;
import com.lab_440.tentacles.common.RemoteCall;
import com.lab_440.tentacles.common.RequestItemCodec;
import com.lab_440.tentacles.common.item.RequestItem;
import com.lab_440.tentacles.slave.ExecutorVerticle;
import com.lab_440.tentacles.slave.PlannerVerticle;
import com.lab_440.tentacles.slave.registration.IRegistration;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class SlaveRunner
extends AbstractRunner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String plannerVerticleID;
    private String executorVertileID;

    @Override
    public void stop() {
        this.logger.info((Object)"stopping a slave runner...");
        if (this.vertx == null) {
            return;
        }
        this.vertx.eventBus().unregisterDefaultCodec(RequestItem.class);
        if (this.plannerVerticleID != null) {
            this.undeployVerticle(this.plannerVerticleID, "Successfully undeployed a planner verticle", "Failed to undeploy a planner verticle");
        }
        if (this.executorVertileID != null) {
            this.undeployVerticle(this.executorVertileID, "Successfully undeployed a executor verticle", "Failed to undeploy a executor verticle");
        }
    }

    @Override
    public void runWithConf(Configuration conf) {
        String crawlerRegName;
        this.conf = conf;
        if (conf.getRole() != Configuration.Role.SLAVE) {
            this.logger.error((Object)"Run slave with wrong config {}", new Object[]{conf.toJsonObject().encode()});
            System.exit(255);
        }
        if ((crawlerRegName = conf.getCrawlerRegistration()) == null || crawlerRegName.isEmpty()) {
            this.logger.warn((Object)"No crawler registration class found, will use default downloader and parser for all requests");
        } else {
            try {
                IRegistration registration = (IRegistration)Class.forName(crawlerRegName).newInstance();
                registration.registAll(this.vertx);
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to regist downloaders and parsers");
            }
        }
        this.run();
    }

    private void run() {
        this.logger.info((Object)("Role: " + (Object)((Object)this.conf.getRole())));
        this.vertx.eventBus().registerDefaultCodec(RequestItem.class, (MessageCodec)RequestItemCodec.getInstance());
        DeploymentOptions options = new DeploymentOptions().setConfig(this.conf.toJsonObject());
        RemoteCall rc = new RemoteCall(this.vertx, this.conf.getMasterHost(), this.conf.getMasterPort());
        rc.checkMasterStatus((Handler<Buffer>)((Handler)resp -> {
            this.deployPlannerVerticle(this.conf, options);
            this.deployExecutorVerticles(this.conf, options);
        }), (Handler<Throwable>)((Handler)err -> {
            this.logger.error((Object)"Master doesn't exist! Should run master verticle first!");
            System.exit(255);
        }));
    }

    private void deployPlannerVerticle(Configuration conf, DeploymentOptions options) {
        this.vertx.deployVerticle(PlannerVerticle.class.getName(), options, res -> {
            if (res.succeeded()) {
                this.plannerVerticleID = (String)res.result();
                this.logger.info((Object)"Successfully deployed planner verticle");
            } else {
                this.logger.error((Object)"Failed to deploy planner verticle: {}", res.cause());
                System.exit(255);
            }
        });
    }

    private void deployExecutorVerticles(Configuration conf, DeploymentOptions options) {
        this.vertx.deployVerticle(ExecutorVerticle.class.getName(), options.setInstances(conf.getExecutorNum()), res -> {
            if (res.succeeded()) {
                this.executorVertileID = (String)res.result();
                this.logger.info((Object)"Successfully deployed executor verticles");
            } else {
                this.logger.error((Object)"Failed to deploy executor verticles: {}", res.cause());
                System.exit(255);
            }
        });
    }
}

