/*
 * Decompiled with CFR 0.152.
 */
package com.lab_440.tentacles.slave.parser;

import com.lab_440.tentacles.common.ProcessStatus;
import com.lab_440.tentacles.common.item.AbstractItem;
import com.lab_440.tentacles.common.item.GeneralResultAbstractItem;
import com.lab_440.tentacles.slave.parser.IParser;
import com.lab_440.tentacles.slave.parser.ParseMethod;
import com.lab_440.tentacles.slave.parser.ParseRule;
import de.jetwick.snacktory.ArticleTextExtractor;
import de.jetwick.snacktory.JResult;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.regex.Pattern;

public class BaseParser
implements IParser {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String url;
    private String page;
    private ProcessStatus status;
    private List<AbstractItem> items;
    private List<String> followUrls;
    private List<ParseMethod> parseMethods;
    private ArticleTextExtractor extractor;

    @Override
    public void init() {
        PriorityQueue<ParseMethod> priQueue = new PriorityQueue<ParseMethod>(64, (a, b) -> a.getPriority() - b.getPriority());
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            ParseRule annotation = methods[i].getAnnotation(ParseRule.class);
            if (annotation == null) continue;
            ParseMethod parseMethod = new ParseMethod(methods[i], annotation.priority(), Pattern.compile(annotation.uriPattern()));
            priQueue.add(parseMethod);
        }
        this.parseMethods = new ArrayList<ParseMethod>(priQueue.size());
        while (priQueue.size() > 0) {
            ParseMethod parseMethod = (ParseMethod)priQueue.poll();
            this.parseMethods.add(parseMethod);
        }
        this.extractor = new ArticleTextExtractor();
        this.items = new ArrayList<AbstractItem>();
        this.followUrls = new ArrayList<String>();
    }

    @Override
    public void parse(String url, String page) throws Exception {
        this.url = url;
        this.page = page;
        this.items.clear();
        this.followUrls.clear();
        for (ParseMethod rule : this.parseMethods) {
            Pattern ptn = rule.getUriPattern();
            if (!ptn.matcher(url).find()) continue;
            rule.getMethod().invoke((Object)this, new Object[0]);
            break;
        }
    }

    @Override
    public ProcessStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcessStatus status) {
        this.status = status;
    }

    @Override
    public List<AbstractItem> getItems() {
        return this.items;
    }

    @Override
    public List<String> getFollowUrls() {
        return this.followUrls;
    }

    @ParseRule(priority=999, uriPattern=".*")
    public void parseGeneral() throws Exception {
        JResult jres = this.extractor.extractContent(this.getPage());
        GeneralResultAbstractItem item = new GeneralResultAbstractItem();
        item.setUrl(this.getUrl());
        item.setTitle(jres.getTitle());
        item.setDate(jres.getDate());
        item.setContent(jres.getText());
        this.addItem(item);
    }

    public String getUrl() {
        return this.url;
    }

    public String getPage() {
        return this.page;
    }

    public void addItem(AbstractItem item) {
        this.items.add(item);
    }

    public void followUrl(String url) {
        this.followUrls.add(url);
    }
}

