/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.util.comparator;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;

public class RepositoryModelModifiedDateComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "modifiedDate ASC";
    public static final String ORDER_BY_DESC = "modifiedDate DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"modifiedDate"};
    public static final String ORDER_BY_MODEL_ASC = "modelFolder DESC, modifiedDate ASC";
    public static final String ORDER_BY_MODEL_DESC = "modelFolder DESC, modifiedDate DESC";
    private final boolean _ascending;
    private final boolean _orderByModel;

    public RepositoryModelModifiedDateComparator() {
        this(false);
    }

    public RepositoryModelModifiedDateComparator(boolean ascending) {
        this._ascending = ascending;
        this._orderByModel = false;
    }

    public RepositoryModelModifiedDateComparator(boolean ascending, boolean orderByModel) {
        this._ascending = ascending;
        this._orderByModel = orderByModel;
    }

    @Override
    public int compare(T t1, T t2) {
        int value = 0;
        Date modifiedDate1 = this.getModifiedDate(t1);
        Date modifiedDate2 = this.getModifiedDate(t2);
        value = this._orderByModel ? ((t1 instanceof DLFolder || t1 instanceof Folder) && (t2 instanceof DLFolder || t2 instanceof Folder) ? DateUtil.compareTo(modifiedDate1, modifiedDate2) : (t1 instanceof DLFolder || t1 instanceof Folder ? -1 : (t2 instanceof DLFolder || t2 instanceof Folder ? 1 : DateUtil.compareTo(modifiedDate1, modifiedDate2)))) : DateUtil.compareTo(modifiedDate1, modifiedDate2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._orderByModel) {
            if (this._ascending) {
                return ORDER_BY_MODEL_ASC;
            }
            return ORDER_BY_MODEL_DESC;
        }
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }

    protected Date getModifiedDate(Object object) {
        if (object instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)object;
            return dlFileEntry.getModifiedDate();
        }
        if (object instanceof DLFileShortcut) {
            DLFileShortcut dlFileShortcut = (DLFileShortcut)object;
            return dlFileShortcut.getModifiedDate();
        }
        if (object instanceof DLFolder) {
            DLFolder dlFolder = (DLFolder)object;
            return dlFolder.getModifiedDate();
        }
        RepositoryEntry repositoryEntry = (RepositoryEntry)object;
        return repositoryEntry.getModifiedDate();
    }
}

