/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.kernel;

import com.liferay.dynamic.data.mapping.kernel.DDMForm;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.kernel.LocalizedValue;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DDMFormField
implements Serializable {
    private DDMForm _ddmForm;
    private List<DDMFormField> _nestedDDMFormFields = new ArrayList<DDMFormField>();
    private final Map<String, Object> _properties = new LinkedHashMap<String, Object>();

    public DDMFormField(String name, String type) {
        this.setName(name);
        this.setType(type);
        this.setDDMFormFieldOptions(new DDMFormFieldOptions());
        this.setLabel(new LocalizedValue());
        this.setPredefinedValue(new LocalizedValue());
        this.setStyle(new LocalizedValue());
        this.setTip(new LocalizedValue());
    }

    public void addNestedDDMFormField(DDMFormField nestedDDMFormField) {
        nestedDDMFormField.setDDMForm(this._ddmForm);
        this._nestedDDMFormFields.add(nestedDDMFormField);
    }

    public String getDataType() {
        return MapUtil.getString(this._properties, "dataType");
    }

    public DDMForm getDDMForm() {
        return this._ddmForm;
    }

    public DDMFormFieldOptions getDDMFormFieldOptions() {
        return (DDMFormFieldOptions)this._properties.get("options");
    }

    public String getFieldNamespace() {
        return MapUtil.getString(this._properties, "fieldNamespace");
    }

    public String getIndexType() {
        return MapUtil.getString(this._properties, "indexType");
    }

    public LocalizedValue getLabel() {
        return (LocalizedValue)this._properties.get("label");
    }

    public String getName() {
        return MapUtil.getString(this._properties, "name");
    }

    public List<DDMFormField> getNestedDDMFormFields() {
        return this._nestedDDMFormFields;
    }

    public Map<String, DDMFormField> getNestedDDMFormFieldsMap() {
        LinkedHashMap<String, DDMFormField> nestedDDMFormFieldsMap = new LinkedHashMap<String, DDMFormField>();
        for (DDMFormField nestedDDMFormField : this._nestedDDMFormFields) {
            nestedDDMFormFieldsMap.put(nestedDDMFormField.getName(), nestedDDMFormField);
            nestedDDMFormFieldsMap.putAll(nestedDDMFormField.getNestedDDMFormFieldsMap());
        }
        return nestedDDMFormFieldsMap;
    }

    public LocalizedValue getPredefinedValue() {
        return (LocalizedValue)this._properties.get("predefinedValue");
    }

    public Map<String, Object> getProperties() {
        return this._properties;
    }

    public Object getProperty(String name) {
        return this._properties.get(name);
    }

    public LocalizedValue getStyle() {
        return (LocalizedValue)this._properties.get("style");
    }

    public LocalizedValue getTip() {
        return (LocalizedValue)this._properties.get("tip");
    }

    public String getType() {
        return MapUtil.getString(this._properties, "type");
    }

    public boolean isLocalizable() {
        return MapUtil.getBoolean(this._properties, "localizable");
    }

    public boolean isMultiple() {
        return MapUtil.getBoolean(this._properties, "multiple");
    }

    public boolean isReadOnly() {
        return MapUtil.getBoolean(this._properties, "readOnly");
    }

    public boolean isRepeatable() {
        return MapUtil.getBoolean(this._properties, "repeatable");
    }

    public boolean isRequired() {
        return MapUtil.getBoolean(this._properties, "required");
    }

    public boolean isShowLabel() {
        return MapUtil.getBoolean(this._properties, "showLabel");
    }

    public boolean isTransient() {
        return Validator.isNull(this.getDataType());
    }

    public void setDataType(String dataType) {
        this._properties.put("dataType", dataType);
    }

    public void setDDMForm(DDMForm ddmForm) {
        for (DDMFormField nestedDDMFormField : this._nestedDDMFormFields) {
            nestedDDMFormField.setDDMForm(ddmForm);
        }
        this._ddmForm = ddmForm;
    }

    public void setDDMFormFieldOptions(DDMFormFieldOptions ddmFormFieldOptions) {
        this._properties.put("options", ddmFormFieldOptions);
    }

    public void setFieldNamespace(String fieldNamespace) {
        this._properties.put("fieldNamespace", fieldNamespace);
    }

    public void setIndexType(String indexType) {
        this._properties.put("indexType", indexType);
    }

    public void setLabel(LocalizedValue label) {
        this._properties.put("label", label);
    }

    public void setLocalizable(boolean localizable) {
        this._properties.put("localizable", localizable);
    }

    public void setMultiple(boolean multiple) {
        this._properties.put("multiple", multiple);
    }

    public void setName(String name) {
        this._properties.put("name", name);
    }

    public void setNestedDDMFormFields(List<DDMFormField> nestedDDMFormFields) {
        this._nestedDDMFormFields = nestedDDMFormFields;
    }

    public void setPredefinedValue(LocalizedValue predefinedValue) {
        this._properties.put("predefinedValue", predefinedValue);
    }

    public void setProperty(String name, Object value) {
        this._properties.put(name, value);
    }

    public void setReadOnly(boolean readOnly) {
        this._properties.put("readOnly", readOnly);
    }

    public void setRepeatable(boolean repeatable) {
        this._properties.put("repeatable", repeatable);
    }

    public void setRequired(boolean required) {
        this._properties.put("required", required);
    }

    public void setShowLabel(boolean showLabel) {
        this._properties.put("showLabel", showLabel);
    }

    public void setStyle(LocalizedValue style) {
        this._properties.put("style", style);
    }

    public void setTip(LocalizedValue tip) {
        this._properties.put("tip", tip);
    }

    public void setType(String type) {
        this._properties.put("type", type);
    }
}

