/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.exception;

import com.liferay.portal.kernel.exception.PortalException;

public class RequiredGroupException
extends PortalException {
    private RequiredGroupException(String message) {
        super(message);
    }

    public static class MustNotDeleteSystemGroup
    extends RequiredGroupException {
        public long groupId;

        public MustNotDeleteSystemGroup(long groupId) {
            super(String.format("Site %s cannot be deleted because it is a system required site", groupId));
            this.groupId = groupId;
        }
    }

    public static class MustNotDeleteGroupThatHasChild
    extends RequiredGroupException {
        public long groupId;

        public MustNotDeleteGroupThatHasChild(long groupId) {
            super(String.format("Site %s cannot be deleted because it has child sites", groupId));
            this.groupId = groupId;
        }
    }

    public static class MustNotDeleteCurrentGroup
    extends RequiredGroupException {
        public long groupId;

        public MustNotDeleteCurrentGroup(long groupId) {
            super(String.format("Site %s cannot be deleted because it is currently being accessed", groupId));
            this.groupId = groupId;
        }
    }
}

