/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.petra.nio.CharsetDecoderUtil;
import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.petra.string.StringPool;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class WriterOutputStream
extends OutputStream {
    private static final int _DEFAULT_OUTPUT_BUFFER_SIZE = 8192;
    private final boolean _autoFlush;
    private final CharsetDecoder _charsetDecoder;
    private final String _charsetName;
    private final ByteBuffer _inputByteBuffer;
    private final CharBuffer _outputCharBuffer;
    private final Writer _writer;

    public WriterOutputStream(Writer writer) {
        this(writer, StringPool.DEFAULT_CHARSET_NAME, 8192, false);
    }

    public WriterOutputStream(Writer writer, String charsetName) {
        this(writer, charsetName, 8192, false);
    }

    public WriterOutputStream(Writer writer, String charsetName, boolean autoFlush) {
        this(writer, charsetName, 8192, autoFlush);
    }

    public WriterOutputStream(Writer writer, String charsetName, int outputBufferSize) {
        this(writer, charsetName, outputBufferSize, false);
    }

    public WriterOutputStream(Writer writer, String charsetName, int outputBufferSize, boolean autoFlush) {
        if (outputBufferSize <= 0) {
            if (autoFlush) {
                outputBufferSize = 8192;
            } else {
                throw new IllegalArgumentException("Output buffer size " + outputBufferSize + " must be a positive number");
            }
        }
        if (charsetName == null) {
            charsetName = StringPool.DEFAULT_CHARSET_NAME;
        }
        this._writer = writer;
        this._charsetName = charsetName;
        this._charsetDecoder = CharsetDecoderUtil.getCharsetDecoder((String)charsetName);
        CharsetEncoder charsetEncoder = CharsetEncoderUtil.getCharsetEncoder((String)charsetName);
        this._inputByteBuffer = ByteBuffer.allocate((int)Math.ceil(charsetEncoder.maxBytesPerChar()));
        this._inputByteBuffer.limit(0);
        this._outputCharBuffer = CharBuffer.allocate(outputBufferSize);
        this._autoFlush = autoFlush;
    }

    @Override
    public void close() throws IOException {
        this._decode(this._inputByteBuffer, true);
        this._flushBuffer();
        this._writer.close();
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        this._writer.flush();
    }

    public String getEncoding() {
        return this._charsetName;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        while (this._inputByteBuffer.hasRemaining()) {
            this.write(bytes[offset++]);
            --length;
        }
        ByteBuffer inputByteBuffer = ByteBuffer.wrap(bytes, offset, length);
        this._decode(inputByteBuffer, false);
        if (inputByteBuffer.hasRemaining()) {
            this._inputByteBuffer.limit(inputByteBuffer.remaining());
            this._inputByteBuffer.put(inputByteBuffer);
            this._inputByteBuffer.flip();
        }
    }

    @Override
    public void write(int b) throws IOException {
        int limit = this._inputByteBuffer.limit();
        this._inputByteBuffer.limit(limit + 1);
        this._inputByteBuffer.put(limit, (byte)b);
        this._decode(this._inputByteBuffer, false);
        if (!this._inputByteBuffer.hasRemaining()) {
            this._inputByteBuffer.position(0);
            this._inputByteBuffer.limit(0);
        }
    }

    private void _decode(ByteBuffer inputByteBuffer, boolean endOfInput) throws IOException {
        CoderResult coderResult;
        while ((coderResult = this._charsetDecoder.decode(inputByteBuffer, this._outputCharBuffer, endOfInput)).isOverflow()) {
            this._flushBuffer();
        }
        if (coderResult.isUnderflow()) {
            if (this._autoFlush) {
                this._flushBuffer();
            }
        } else {
            throw new IOException("Unexcepted coder result " + coderResult);
        }
    }

    private void _flushBuffer() throws IOException {
        if (this._outputCharBuffer.position() > 0) {
            this._writer.write(this._outputCharBuffer.array(), 0, this._outputCharBuffer.position());
            this._outputCharBuffer.rewind();
        }
    }
}

