/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.language;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.memory.FinalizeManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class UTF8Control
extends ResourceBundle.Control {
    public static final UTF8Control INSTANCE = new UTF8Control();
    private static final Map<ClassLoader, Map<URL, ResourceBundle>> _resourceBundlesMap = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        return null;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader classLoader, boolean reload) throws IOException {
        ResourceBundle resourceBundle;
        Map<URL, ResourceBundle> resourceBundles;
        URL url = classLoader.getResource(this.toResourceName(this.toBundleName(baseName, locale), "properties"));
        if (url == null) {
            return null;
        }
        if (!reload && (resourceBundles = _resourceBundlesMap.get(classLoader)) != null && (resourceBundle = resourceBundles.get(url)) != null) {
            return resourceBundle;
        }
        URLConnection urlConnection = url.openConnection();
        urlConnection.setUseCaches(!reload);
        try (InputStream inputStream = urlConnection.getInputStream();){
            PropertyResourceBundle resourceBundle2 = new PropertyResourceBundle(new InputStreamReader(inputStream, "UTF-8"));
            Map resourceBundles2 = _resourceBundlesMap.computeIfAbsent(classLoader, key -> new ConcurrentHashMap());
            resourceBundles2.put(url, resourceBundle2);
            PropertyResourceBundle propertyResourceBundle = resourceBundle2;
            return propertyResourceBundle;
        }
    }
}

