/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class LayoutSetStagingHandler
implements InvocationHandler,
Serializable {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetStagingHandler.class);
    private static final Set<String> _layoutSetBranchMethodNames = new HashSet<String>(Arrays.asList("getColorScheme", "getColorSchemeId", "getCss", "getLayoutSetPrototypeLinkEnabled", "getLayoutSetPrototypeUuid", "getLogo", "getLogoId", "getSettings", "getSettingsProperties", "getSettingsProperty", "getTheme", "getThemeId", "getThemeSetting", "isEscapedModel", "isLayoutSetPrototypeLinkActive", "isLogo", "setColorSchemeId", "setCss", "setLayoutSetPrototypeLinkEnabled", "setLayoutSetPrototypeUuid", "setLogoId", "setSettings", "setSettingsProperties", "setThemeId"));
    private final LayoutSet _layoutSet;
    private LayoutSetBranch _layoutSetBranch;

    public LayoutSetStagingHandler(LayoutSet layoutSet) {
        this._layoutSet = layoutSet;
        try {
            this._layoutSetBranch = this._getLayoutSetBranch(layoutSet);
        }
        catch (Exception exception) {
            _log.error(exception, exception);
            throw new IllegalStateException(exception);
        }
    }

    public LayoutSet getLayoutSet() {
        return this._layoutSet;
    }

    public LayoutSetBranch getLayoutSetBranch() {
        return this._layoutSetBranch;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            String methodName = method.getName();
            if (methodName.equals("getWrappedModel")) {
                return this._layoutSet;
            }
            if (this._layoutSetBranch == null) {
                return method.invoke((Object)this._layoutSet, arguments);
            }
            if (methodName.equals("clone")) {
                return this._clone();
            }
            if (methodName.equals("toEscapedModel")) {
                if (this._layoutSet.isEscapedModel()) {
                    return this;
                }
                return this._toEscapedModel();
            }
            BaseModel<LayoutSet> bean = this._layoutSet;
            if (_layoutSetBranchMethodNames.contains(methodName)) {
                try {
                    Class<?> layoutSetBranchClass = this._layoutSetBranch.getClass();
                    method = layoutSetBranchClass.getMethod(methodName, method.getParameterTypes());
                    bean = this._layoutSetBranch;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    _log.error(noSuchMethodException, noSuchMethodException);
                }
            }
            return method.invoke((Object)bean, arguments);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    public void setLayoutSetBranch(LayoutSetBranch layoutSetBranch) {
        this._layoutSetBranch = layoutSetBranch;
    }

    private Object _clone() {
        return ProxyUtil.newProxyInstance(PortalClassLoaderUtil.getClassLoader(), new Class[]{LayoutSet.class, ModelWrapper.class}, new LayoutSetStagingHandler((LayoutSet)this._layoutSet.clone()));
    }

    private LayoutSetBranch _getLayoutSetBranch(LayoutSet layoutSet) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return null;
        }
        long layoutSetBranchId = ParamUtil.getLong(serviceContext, "layoutSetBranchId");
        if (layoutSetBranchId > 0L) {
            return LayoutSetBranchLocalServiceUtil.getLayoutSetBranch(layoutSetBranchId);
        }
        if (serviceContext.isSignedIn()) {
            return LayoutSetBranchLocalServiceUtil.getUserLayoutSetBranch(serviceContext.getUserId(), layoutSet.getGroupId(), layoutSet.isPrivateLayout(), layoutSet.getLayoutSetId(), layoutSetBranchId);
        }
        return LayoutSetBranchLocalServiceUtil.getMasterLayoutSetBranch(layoutSet.getGroupId(), layoutSet.isPrivateLayout());
    }

    private Object _toEscapedModel() {
        return ProxyUtil.newProxyInstance(PortalClassLoaderUtil.getClassLoader(), new Class[]{LayoutSet.class, ModelWrapper.class}, new LayoutSetStagingHandler((LayoutSet)this._layoutSet.toEscapedModel()));
    }
}

