/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.notifications;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.Channel;
import com.liferay.portal.kernel.notifications.ChannelException;
import com.liferay.portal.kernel.notifications.ChannelListener;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BaseChannelImpl
implements Channel {
    protected final Lock lock = new ReentrantLock();
    private static final Log _log = LogFactoryUtil.getLog(BaseChannelImpl.class);
    private List<ChannelListener> _channelListeners;
    private long _cleanUpInterval;
    private final long _companyId;
    private long _nextCleanUpTime;
    private final long _userId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() throws ChannelException {
        block6: {
            this.lock.lock();
            try {
                long currentTime = System.currentTimeMillis();
                if (currentTime <= this._nextCleanUpTime) break block6;
                this._nextCleanUpTime = currentTime + this._cleanUpInterval;
                try {
                    this.doCleanUp();
                }
                catch (ChannelException channelException) {
                    throw channelException;
                }
                catch (Exception exception) {
                    throw new ChannelException(exception);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void close() throws ChannelException {
        this.flush();
    }

    public long getCompanyId() {
        return this._companyId;
    }

    @Override
    public List<NotificationEvent> getNotificationEvents() throws ChannelException {
        return this.getNotificationEvents(true);
    }

    @Override
    public long getUserId() {
        return this._userId;
    }

    public boolean hasNotificationEvents() {
        try {
            List<NotificationEvent> notificationEvents = this.getNotificationEvents(false);
            if (!notificationEvents.isEmpty()) {
                return true;
            }
        }
        catch (ChannelException channelException) {
            _log.error("Unable to fetch notifications", channelException);
        }
        return false;
    }

    @Override
    public void registerChannelListener(ChannelListener channelListener) {
        this.lock.lock();
        try {
            List<ChannelListener> channelListeners = this._getChannelListeners();
            channelListeners.add(channelListener);
            if (this.hasNotificationEvents()) {
                this.notifyChannelListeners();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCleanUpInterval(long cleanUpInterval) {
        this._cleanUpInterval = cleanUpInterval;
    }

    @Override
    public void unregisterChannelListener(ChannelListener channelListener) {
        this.lock.lock();
        try {
            List<ChannelListener> channelListeners = this._getChannelListeners();
            channelListeners.remove(channelListener);
        }
        finally {
            this.lock.unlock();
        }
        channelListener.channelListenerRemoved(this._userId);
    }

    protected BaseChannelImpl(long companyId, long userId) {
        this._companyId = companyId;
        this._userId = userId;
    }

    protected abstract void doCleanUp() throws Exception;

    protected void notifyChannelListeners() {
        for (ChannelListener channelListener : this._getChannelListeners()) {
            channelListener.notificationEventsAvailable(this._userId);
        }
    }

    private List<ChannelListener> _getChannelListeners() {
        if (this._channelListeners == null) {
            this._channelListeners = new ArrayList<ChannelListener>();
        }
        return this._channelListeners;
    }
}

