/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.notifications;

import com.liferay.portal.kernel.notifications.UserNotificationDeliveryType;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class UserNotificationDefinition {
    public static final int NOTIFICATION_TYPE_ADD_ENTRY = 0;
    public static final int NOTIFICATION_TYPE_UPDATE_ENTRY = 1;
    private final long _classNameId;
    private final String _description;
    private final int _notificationType;
    private final String _portletId;
    private final Map<Integer, UserNotificationDeliveryType> _userNotificationDeliveryTypes = new HashMap<Integer, UserNotificationDeliveryType>();

    public UserNotificationDefinition(String portletId, long classNameId, int notificationType, String description) {
        this._portletId = portletId;
        this._classNameId = classNameId;
        this._notificationType = notificationType;
        this._description = description;
    }

    public void addUserNotificationDeliveryType(UserNotificationDeliveryType userNotificationDeliveryType) {
        this._userNotificationDeliveryTypes.put(userNotificationDeliveryType.getType(), userNotificationDeliveryType);
    }

    public long getClassNameId() {
        return this._classNameId;
    }

    public String getDescription(Locale locale) {
        String description = ResourceBundleUtil.getString(this.getResourceBundle(locale), this._description);
        if (description != null) {
            return description;
        }
        return this._description;
    }

    public int getNotificationType() {
        return this._notificationType;
    }

    public String getPortletId() {
        return this._portletId;
    }

    public UserNotificationDeliveryType getUserNotificationDeliveryType(int deliveryType) {
        return this._userNotificationDeliveryTypes.get(deliveryType);
    }

    public Map<Integer, UserNotificationDeliveryType> getUserNotificationDeliveryTypes() {
        return this._userNotificationDeliveryTypes;
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        try {
            return ResourceBundleUtil.getBundle("content.Language", locale, this.getClass());
        }
        catch (MissingResourceException missingResourceException) {
            return ResourceBundleUtil.getBundle("content.Language", locale, PortalClassLoaderUtil.getClassLoader());
        }
    }
}

