/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository.proxy;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.repository.proxy.RepositoryModelProxyBean;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class LocalRepositoryProxyBean
extends RepositoryModelProxyBean
implements LocalRepository {
    private final LocalRepository _localRepository;

    public LocalRepositoryProxyBean(LocalRepository localRepository, ClassLoader classLoader) {
        super(classLoader);
        this._localRepository = localRepository;
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = this._localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream inputStream, long size, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = this._localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, inputStream, size, serviceContext);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public FileShortcut addFileShortcut(long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        FileShortcut fileShortcut = this._localRepository.addFileShortcut(userId, folderId, toFileEntryId, serviceContext);
        return this.newFileShortcutProxyBean(fileShortcut);
    }

    @Override
    public Folder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        Folder folder = this._localRepository.addFolder(userId, parentFolderId, name, description, serviceContext);
        return this.newFolderProxyBean(folder);
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        this._localRepository.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        this._localRepository.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
    }

    @Override
    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = this._localRepository.copyFileEntry(userId, groupId, fileEntryId, destFolderId, serviceContext);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public void deleteAll() throws PortalException {
        this._localRepository.deleteAll();
    }

    @Override
    public void deleteFileEntry(long fileEntryId) throws PortalException {
        this._localRepository.deleteFileEntry(fileEntryId);
    }

    @Override
    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        this._localRepository.deleteFileShortcut(fileShortcutId);
    }

    @Override
    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        this._localRepository.deleteFileShortcuts(toFileEntryId);
    }

    @Override
    public void deleteFileVersion(long fileVersionId) throws PortalException {
        this._localRepository.deleteFileVersion(fileVersionId);
    }

    @Override
    public void deleteFolder(long folderId) throws PortalException {
        this._localRepository.deleteFolder(folderId);
    }

    @Override
    public <T extends Capability> T getCapability(Class<T> capabilityClass) {
        return this._localRepository.getCapability(capabilityClass);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this._localRepository.getFileEntries(folderId, status, start, end, orderByComparator);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this._localRepository.getFileEntries(folderId, start, end, orderByComparator);
    }

    @Override
    public List<RepositoryEntry> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException {
        return this._localRepository.getFileEntriesAndFileShortcuts(folderId, status, start, end);
    }

    @Override
    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws PortalException {
        return this._localRepository.getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    @Override
    public int getFileEntriesCount(long folderId) throws PortalException {
        return this._localRepository.getFileEntriesCount(folderId);
    }

    @Override
    public int getFileEntriesCount(long folderId, int status) throws PortalException {
        return this._localRepository.getFileEntriesCount(folderId, status);
    }

    @Override
    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        return this.newFileEntryProxyBean(this._localRepository.getFileEntry(fileEntryId));
    }

    @Override
    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        return this.newFileEntryProxyBean(this._localRepository.getFileEntry(folderId, title));
    }

    @Override
    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        FileEntry fileEntry = this._localRepository.getFileEntryByUuid(uuid);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        return this.newFileShortcutProxyBean(this._localRepository.getFileShortcut(fileShortcutId));
    }

    @Override
    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        return this.newFileVersionProxyBean(this._localRepository.getFileVersion(fileVersionId));
    }

    @Override
    public Folder getFolder(long folderId) throws PortalException {
        return this.newFolderProxyBean(this._localRepository.getFolder(folderId));
    }

    @Override
    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        return this._localRepository.getFolder(parentFolderId, name);
    }

    @Override
    public List<Folder> getFolders(long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        return this._localRepository.getFolders(parentFolderId, includeMountFolders, start, end, orderByComparator);
    }

    @Override
    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        return this._localRepository.getFolders(parentFolderId, status, includeMountFolders, start, end, orderByComparator);
    }

    @Override
    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        return this._localRepository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, includeMountFolders, start, end, orderByComparator);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws PortalException {
        return this._localRepository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, includeMountFolders);
    }

    @Override
    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        return this._localRepository.getFoldersCount(parentFolderId, includeMountfolders);
    }

    @Override
    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        return this._localRepository.getFoldersCount(parentFolderId, status, includeMountfolders);
    }

    @Override
    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this._localRepository.getRepositoryFileEntries(userId, rootFolderId, start, end, orderByComparator);
    }

    @Override
    public long getRepositoryId() {
        return this._localRepository.getRepositoryId();
    }

    @Override
    public <T extends Capability> boolean isCapabilityProvided(Class<T> capabilityClass) {
        return this._localRepository.isCapabilityProvided(capabilityClass);
    }

    @Override
    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = this._localRepository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        Folder folder = this._localRepository.moveFolder(userId, folderId, parentFolderId, serviceContext);
        return this.newFolderProxyBean(folder);
    }

    @Override
    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        this._localRepository.revertFileEntry(userId, fileEntryId, version, serviceContext);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = this._localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, file, serviceContext);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = this._localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, inputStream, size, serviceContext);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        FileShortcut fileShortcut = this._localRepository.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
        return this.newFileShortcutProxyBean(fileShortcut);
    }

    @Override
    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        this._localRepository.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    @Override
    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._localRepository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
    }
}

