/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.ResourcedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.ExpandoQueryContributor;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelperUtil;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.PreFilterContributor;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SearchResultPermissionFilter;
import com.liferay.portal.kernel.search.SearchResultPermissionFilterFactory;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.MultiValueFacet;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.search.hits.HitsProcessorRegistryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RegionServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.collections.ServiceTrackerCollections;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public abstract class BaseIndexer<T>
implements Indexer<T> {
    private static final long _DEFAULT_FOLDER_ID = 0L;
    private static final Log _log = LogFactoryUtil.getLog(BaseIndexer.class);
    private static volatile ExpandoQueryContributor _expandoQueryContributor = ServiceProxyFactory.newServiceTrackedInstance(ExpandoQueryContributor.class, BaseIndexer.class, "_expandoQueryContributor", false);
    private static volatile PreFilterContributor _preFilterContributor = ServiceProxyFactory.newServiceTrackedInstance(PreFilterContributor.class, BaseIndexer.class, "_preFilterContributor", false);
    private static volatile SearchResultPermissionFilterFactory _searchResultPermissionFilterFactory = ServiceProxyFactory.newServiceTrackedInstance(SearchResultPermissionFilterFactory.class, BaseIndexer.class, "_searchResultPermissionFilterFactory", false);
    private boolean _commitImmediately;
    private String[] _defaultSelectedFieldNames;
    private String[] _defaultSelectedLocalizedFieldNames;
    private final Document _document = new DocumentImpl();
    private List<DocumentContributor<?>> _documentContributors;
    private boolean _filterSearch;
    private Boolean _indexerEnabled;
    private IndexerPostProcessor[] _indexerPostProcessors = new IndexerPostProcessor[0];
    private boolean _permissionAware;
    private String _searchEngineId;
    private boolean _selectAllLocales;
    private boolean _stagingAware = true;

    @Override
    public void delete(long companyId, String uid) throws SearchException {
        try {
            IndexWriterHelperUtil.deleteDocument(this.getSearchEngineId(), companyId, uid, this._commitImmediately);
        }
        catch (SearchException searchException) {
            throw searchException;
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
    }

    @Override
    public void delete(T object) throws SearchException {
        CTModel ctModel;
        if (object == null) {
            return;
        }
        if (object instanceof CTModel && (ctModel = (CTModel)object).getCtCollectionId() == 0L && !CTCollectionThreadLocal.isProductionMode()) {
            return;
        }
        try {
            this.doDelete(object);
        }
        catch (SearchException searchException) {
            throw searchException;
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Indexer)) {
            return false;
        }
        Indexer indexer = (Indexer)object;
        return Objects.equals(this.getClassName(), indexer.getClassName());
    }

    @Override
    public Document getDocument(T object) throws SearchException {
        try {
            Document document = this.doGetDocument(object);
            for (IndexerPostProcessor indexerPostProcessor : this._indexerPostProcessors) {
                indexerPostProcessor.postProcessDocument(document, object);
            }
            if (document == null) {
                return null;
            }
            Map<String, Field> fields = document.getFields();
            Field groupIdField = fields.get("groupId");
            if (groupIdField != null) {
                long groupId = GetterUtil.getLong(groupIdField.getValue());
                this.addStagingGroupKeyword(document, groupId);
            }
            return document;
        }
        catch (SearchException searchException) {
            throw searchException;
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
    }

    @Override
    public BooleanFilter getFacetBooleanFilter(String className, SearchContext searchContext) throws Exception {
        return null;
    }

    @Override
    public BooleanQuery getFullQuery(SearchContext searchContext) throws SearchException {
        try {
            searchContext.setSearchEngineId(this.getSearchEngineId());
            this.resetFullQuery(searchContext);
            Object[] fullQueryEntryClassNames = searchContext.getFullQueryEntryClassNames();
            if (ArrayUtil.isNotEmpty(fullQueryEntryClassNames)) {
                searchContext.setAttribute("relatedEntryClassNames", (Serializable)this.getSearchClassNames());
            }
            String[] entryClassNames = (String[])ArrayUtil.append(this.getSearchClassNames(), fullQueryEntryClassNames);
            searchContext.setEntryClassNames(entryClassNames);
            BooleanFilter fullQueryBooleanFilter = new BooleanFilter();
            this.addSearchAssetCategoryIds(fullQueryBooleanFilter, searchContext);
            this.addSearchAssetTagNames(fullQueryBooleanFilter, searchContext);
            this.addSearchFolderId(fullQueryBooleanFilter, searchContext);
            this.addSearchLayout(fullQueryBooleanFilter, searchContext);
            this.addSearchUserId(fullQueryBooleanFilter, searchContext);
            Map<String, Indexer<?>> entryClassNameIndexerMap = this._getEntryClassNameIndexerMap(entryClassNames, searchContext.getSearchEngineId());
            this._addPreFilters(fullQueryBooleanFilter, entryClassNameIndexerMap, searchContext);
            BooleanQuery fullQuery = this.createFullQuery(fullQueryBooleanFilter, searchContext);
            fullQuery.setQueryConfig(searchContext.getQueryConfig());
            return fullQuery;
        }
        catch (SearchException searchException) {
            throw searchException;
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
    }

    @Override
    public IndexerPostProcessor[] getIndexerPostProcessors() {
        return this._indexerPostProcessors;
    }

    @Override
    public String[] getSearchClassNames() {
        return new String[]{this.getClassName()};
    }

    @Override
    public String getSearchEngineId() {
        SearchEngine searchEngine;
        if (this._searchEngineId != null) {
            return this._searchEngineId;
        }
        Class<?> clazz = this.getClass();
        String searchEngineId = GetterUtil.getString(PropsUtil.get("index.search.engine.id", new com.liferay.portal.kernel.configuration.Filter(clazz.getName())));
        if (Validator.isNotNull(searchEngineId) && (searchEngine = SearchEngineHelperUtil.getSearchEngine(searchEngineId)) != null) {
            this._searchEngineId = searchEngineId;
        }
        if (this._searchEngineId == null) {
            this._searchEngineId = SearchEngineHelperUtil.getDefaultSearchEngineId();
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat((String[])new String[]{"Search engine ID for ", clazz.getName(), " is ", searchEngineId}));
        }
        return this._searchEngineId;
    }

    @Override
    @Deprecated
    public String getSortField(String orderByCol) {
        String sortField = this.doGetSortField(orderByCol);
        if (this._document.isDocumentSortableTextField(sortField)) {
            return Field.getSortableFieldName(sortField);
        }
        return sortField;
    }

    @Override
    public Summary getSummary(Document document, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws SearchException {
        try {
            Locale locale = this.getLocale(portletRequest);
            Summary summary = this.doGetSummary(document, locale, snippet, portletRequest, portletResponse);
            for (IndexerPostProcessor indexerPostProcessor : this._indexerPostProcessors) {
                indexerPostProcessor.postProcessSummary(summary, document, locale, snippet);
            }
            return summary;
        }
        catch (SearchException searchException) {
            throw searchException;
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
    }

    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getClassName());
    }

    @Override
    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return true;
    }

    @Override
    public boolean isCommitImmediately() {
        return this._commitImmediately;
    }

    @Override
    public boolean isFilterSearch() {
        return this._filterSearch;
    }

    @Override
    public boolean isIndexerEnabled() {
        if (this._indexerEnabled == null) {
            String indexerEnabled = PropsUtil.get("indexer.enabled", new com.liferay.portal.kernel.configuration.Filter(this.getClassName()));
            this._indexerEnabled = GetterUtil.getBoolean(indexerEnabled, true);
            return this._indexerEnabled;
        }
        return this._indexerEnabled;
    }

    @Override
    public boolean isPermissionAware() {
        return this._permissionAware;
    }

    public boolean isSelectAllLocales() {
        return this._selectAllLocales;
    }

    @Override
    public boolean isStagingAware() {
        return this._stagingAware;
    }

    @Override
    public boolean isVisible(long classPK, int status) throws Exception {
        return true;
    }

    @Override
    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
    }

    @Override
    @Deprecated
    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
    }

    @Override
    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        if (Validator.isNull(searchContext.getKeywords())) {
            this.addSearchTerm(searchQuery, searchContext, "description", false);
            this.addSearchTerm(searchQuery, searchContext, "title", false);
            this.addSearchTerm(searchQuery, searchContext, "userName", false);
        }
    }

    @Override
    @Deprecated
    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
    }

    @Override
    public void registerIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor) {
        List<IndexerPostProcessor> indexerPostProcessorsList = ListUtil.fromArray(this._indexerPostProcessors);
        indexerPostProcessorsList.add(indexerPostProcessor);
        this._indexerPostProcessors = indexerPostProcessorsList.toArray(new IndexerPostProcessor[0]);
    }

    @Override
    public void reindex(Collection<T> collection) {
        if (IndexWriterHelperUtil.isIndexReadOnly() || IndexWriterHelperUtil.isIndexReadOnly(this.getClassName()) || !this.isIndexerEnabled() || collection.isEmpty()) {
            return;
        }
        for (T element : collection) {
            try {
                this.reindex(element);
            }
            catch (SearchException searchException) {
                _log.error("Unable to index object: " + element, searchException);
            }
        }
    }

    @Override
    public void reindex(String className, long classPK) throws SearchException {
        try {
            if (IndexWriterHelperUtil.isIndexReadOnly() || IndexWriterHelperUtil.isIndexReadOnly(this.getClassName()) || !this.isIndexerEnabled() || classPK <= 0L) {
                return;
            }
            this.doReindex(className, classPK);
        }
        catch (NoSuchModelException noSuchModelException) {
            if (_log.isWarnEnabled()) {
                _log.warn(StringBundler.concat((Object[])new Object[]{"Unable to index ", className, " ", classPK}), noSuchModelException);
            }
        }
        catch (SearchException searchException) {
            throw searchException;
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
    }

    @Override
    public void reindex(String[] ids) throws SearchException {
        long companyThreadLocalCompanyId = CompanyThreadLocal.getCompanyId();
        try {
            if (IndexWriterHelperUtil.isIndexReadOnly() || IndexWriterHelperUtil.isIndexReadOnly(this.getClassName()) || !this.isIndexerEnabled()) {
                return;
            }
            if (ids.length > 0) {
                CompanyThreadLocal.setCompanyId(GetterUtil.getLong(ids[0]));
            }
            this.doReindex(ids);
        }
        catch (SearchException searchException) {
            throw searchException;
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
        finally {
            CompanyThreadLocal.setCompanyId(companyThreadLocalCompanyId);
        }
    }

    @Override
    public void reindex(T object) throws SearchException {
        try {
            if (IndexWriterHelperUtil.isIndexReadOnly() || IndexWriterHelperUtil.isIndexReadOnly(this.getClassName()) || !this.isIndexerEnabled()) {
                return;
            }
            if (object == null) {
                return;
            }
            this.doReindex(object);
        }
        catch (SearchException searchException) {
            throw searchException;
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
    }

    @Override
    public Hits search(SearchContext searchContext) throws SearchException {
        try {
            Hits hits = null;
            QueryConfig queryConfig = searchContext.getQueryConfig();
            this.addDefaultHighlightFieldNames(queryConfig);
            if (ArrayUtil.isEmpty(queryConfig.getSelectedFieldNames())) {
                this.addDefaultSelectedFieldNames(searchContext);
            }
            this.addFacetSelectedFieldNames(searchContext, queryConfig);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker != null && this.isUseSearchResultPermissionFilter(searchContext)) {
                if (searchContext.getUserId() == 0L) {
                    searchContext.setUserId(permissionChecker.getUserId());
                }
                SearchResultPermissionFilter searchResultPermissionFilter = _searchResultPermissionFilterFactory.create(this::doSearch, permissionChecker);
                hits = searchResultPermissionFilter.search(searchContext);
            } else {
                hits = this.doSearch(searchContext);
            }
            this.processHits(searchContext, hits);
            return hits;
        }
        catch (SearchException searchException) {
            throw searchException;
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
    }

    @Override
    public Hits search(SearchContext searchContext, String ... selectedFieldNames) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setSelectedFieldNames(selectedFieldNames);
        return this.search(searchContext);
    }

    @Override
    public long searchCount(SearchContext searchContext) throws SearchException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null && this.isUseSearchResultPermissionFilter(searchContext)) {
            Hits hits = this.search(searchContext);
            return hits.getLength();
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setHitsProcessingEnabled(false);
        queryConfig.setScoreEnabled(false);
        queryConfig.setQueryIndexingEnabled(false);
        queryConfig.setQuerySuggestionEnabled(false);
        searchContext.setSearchEngineId(this.getSearchEngineId());
        BooleanQuery fullQuery = this.getFullQuery(searchContext);
        fullQuery.setQueryConfig(queryConfig);
        return IndexSearcherHelperUtil.searchCount(searchContext, fullQuery);
    }

    public void setCommitImmediately(boolean commitImmediately) {
        this._commitImmediately = commitImmediately;
    }

    @Override
    public void setIndexerEnabled(boolean indexerEnabled) {
        this._indexerEnabled = indexerEnabled;
    }

    public void setSelectAllLocales(boolean selectAllLocales) {
        this._selectAllLocales = selectAllLocales;
    }

    @Override
    public void unregisterIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor) {
        List<IndexerPostProcessor> indexerPostProcessorsList = ListUtil.fromArray(this._indexerPostProcessors);
        indexerPostProcessorsList.remove(indexerPostProcessor);
        this._indexerPostProcessors = indexerPostProcessorsList.toArray(new IndexerPostProcessor[0]);
    }

    protected void addDefaultHighlightFieldNames(QueryConfig queryConfig) {
        queryConfig.addHighlightFieldNames("assetCategoryTitles");
        if (queryConfig.isHighlightEnabled()) {
            queryConfig.addHighlightFieldNames("content", "description", "title");
        }
    }

    protected void addDefaultSelectedFieldNames(SearchContext searchContext) {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        Set<String> selectedFieldNames = null;
        if (!ArrayUtil.isEmpty(this.getDefaultSelectedFieldNames())) {
            selectedFieldNames = SetUtil.fromArray(this.getDefaultSelectedFieldNames());
            if (searchContext.isIncludeAttachments() || searchContext.isIncludeDiscussions()) {
                selectedFieldNames.add("classNameId");
                selectedFieldNames.add("classPK");
            }
        }
        if (!ArrayUtil.isEmpty(this.getDefaultSelectedLocalizedFieldNames())) {
            if (selectedFieldNames == null) {
                selectedFieldNames = new HashSet<String>();
            }
            if (this.isSelectAllLocales()) {
                this.addSelectedLocalizedFieldNames(selectedFieldNames, LocaleUtil.toLanguageIds(LanguageUtil.getSupportedLocales()));
            } else {
                this.addSelectedLocalizedFieldNames(selectedFieldNames, LocaleUtil.toLanguageId(queryConfig.getLocale()));
            }
        }
        if (selectedFieldNames != null && !selectedFieldNames.isEmpty()) {
            queryConfig.setSelectedFieldNames(selectedFieldNames.toArray(new String[0]));
        }
    }

    @Deprecated
    protected void addFacetClause(SearchContext searchContext, BooleanFilter facetBooleanFilter, Collection<Facet> facets) throws ParseException {
        BooleanQueryImpl facetBooleanQuery = new BooleanQueryImpl();
        for (Facet facet : facets) {
            BooleanClause<Query> facetBooleanClause = facet.getFacetClause();
            if (facetBooleanClause == null) continue;
            facetBooleanQuery.add(facetBooleanClause.getClause(), facetBooleanClause.getBooleanClauseOccur());
        }
        if (!facetBooleanQuery.hasClauses()) {
            return;
        }
        QueryFilter queryFilter = new QueryFilter(facetBooleanQuery);
        facetBooleanFilter.add(queryFilter, BooleanClauseOccur.MUST);
    }

    protected void addFacetSelectedFieldNames(SearchContext searchContext, QueryConfig queryConfig) {
        Object[] selectedFieldNames = queryConfig.getSelectedFieldNames();
        if (ArrayUtil.isEmpty(selectedFieldNames) || selectedFieldNames.length == 1 && ((String)selectedFieldNames[0]).equals("*")) {
            return;
        }
        Set<Object> selectedFieldNameSet = SetUtil.fromArray(selectedFieldNames);
        Map<String, Facet> facets = searchContext.getFacets();
        selectedFieldNameSet.addAll(facets.keySet());
        selectedFieldNames = selectedFieldNameSet.toArray(new String[0]);
        queryConfig.setSelectedFieldNames((String[])selectedFieldNames);
    }

    protected void addLocalizedField(Document document, String field, Locale siteDefaultLocale, Map<Locale, String> map) {
        for (Map.Entry<Locale, String> entry : map.entrySet()) {
            Locale locale = entry.getKey();
            if (locale.equals(siteDefaultLocale)) {
                document.addText(field, entry.getValue());
            }
            String languageId = LocaleUtil.toLanguageId(locale);
            document.addText(LocalizationUtil.getLocalizedName(field, languageId), entry.getValue());
        }
    }

    protected void addSearchAssetCategoryIds(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("assetCategoryIds");
        multiValueFacet.setStatic(true);
        multiValueFacet.setValues(searchContext.getAssetCategoryIds());
        searchContext.addFacet(multiValueFacet);
    }

    protected void addSearchAssetTagNames(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("assetTagNames");
        multiValueFacet.setStatic(true);
        multiValueFacet.setValues(searchContext.getAssetTagNames());
        searchContext.addFacet(multiValueFacet);
    }

    protected Filter addSearchClassTypeIds(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long[] classTypeIds = searchContext.getClassTypeIds();
        if (ArrayUtil.isEmpty(classTypeIds)) {
            return null;
        }
        TermsFilter classTypeIdsTermsFilter = new TermsFilter("classTypeId");
        classTypeIdsTermsFilter.addValues(ArrayUtil.toStringArray(classTypeIds));
        return contextBooleanFilter.add(classTypeIdsTermsFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchEntryClassNames(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
    }

    protected Map<String, Query> addSearchExpando(BooleanQuery searchQuery, SearchContext searchContext, String keywords) throws Exception {
        _expandoQueryContributor.contribute(keywords, searchQuery, this.getSearchClassNames(), searchContext);
        return new HashMap<String, Query>();
    }

    protected void addSearchFolderId(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("treePath");
        multiValueFacet.setStatic(true);
        long[] folderIds = searchContext.getFolderIds();
        if (ArrayUtil.isNotEmpty(folderIds)) {
            folderIds = ArrayUtil.remove(folderIds, 0L);
            multiValueFacet.setValues(folderIds);
        }
        searchContext.addFacet(multiValueFacet);
    }

    protected Map<String, Query> addSearchKeywords(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        return this.addSearchExpando(searchQuery, searchContext, searchContext.getKeywords());
    }

    protected void addSearchLayout(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("layoutUuid");
        multiValueFacet.setStatic(true);
        searchContext.addFacet(multiValueFacet);
    }

    protected Map<String, Query> addSearchLocalizedTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) throws Exception {
        HashMap<String, Query> queries = new HashMap<String, Query>();
        queries.put(field, this.addSearchTerm(searchQuery, searchContext, field, like));
        String localizedFieldName = Field.getLocalizedName(searchContext.getLocale(), field);
        Query localizedQuery = this.addSearchTerm(searchQuery, searchContext, localizedFieldName, like);
        queries.put(localizedFieldName, localizedQuery);
        return queries;
    }

    protected Query addSearchTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) throws Exception {
        Class<?> clazz;
        if (Validator.isNull(field)) {
            return null;
        }
        String value = null;
        Serializable serializable = searchContext.getAttribute(field);
        value = serializable != null ? ((clazz = serializable.getClass()).isArray() ? StringUtil.merge((Object[])serializable) : GetterUtil.getString(serializable)) : GetterUtil.getString(serializable);
        if (Validator.isNotNull(value) && searchContext.getFacet(field) != null) {
            return null;
        }
        if (Validator.isNull(value)) {
            value = searchContext.getKeywords();
        }
        if (Validator.isNull(value)) {
            return null;
        }
        Query query = null;
        query = searchContext.isAndSearch() ? searchQuery.addRequiredTerm(field, value, like) : searchQuery.addTerm(field, value, like);
        return query;
    }

    protected void addSearchUserId(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("userId");
        multiValueFacet.setStatic(true);
        long userId = GetterUtil.getLong(searchContext.getAttribute("userId"));
        if (userId > 0L) {
            multiValueFacet.setValues(new long[]{userId});
        }
        searchContext.addFacet(multiValueFacet);
    }

    protected void addSelectedLocalizedFieldNames(Set<String> selectedFieldNames, String ... languageIds) {
        for (String defaultLocalizedSelectedFieldName : this.getDefaultSelectedLocalizedFieldNames()) {
            selectedFieldNames.add(defaultLocalizedSelectedFieldName);
            for (String languageId : languageIds) {
                String localizedFieldName = LocalizationUtil.getLocalizedName(defaultLocalizedSelectedFieldName, languageId);
                selectedFieldNames.add(localizedFieldName);
            }
        }
    }

    protected void addStagingGroupKeyword(Document document, long groupId) {
        if (!this.isStagingAware()) {
            return;
        }
        document.addKeyword("stagingGroup", this.isStagingGroup(groupId));
    }

    protected void addStatus(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        int[] statuses = GetterUtil.getIntegerValues(searchContext.getAttribute("status"), null);
        if (ArrayUtil.isEmpty(statuses)) {
            int status = GetterUtil.getInteger(searchContext.getAttribute("status"), 0);
            statuses = new int[]{status};
        }
        if (!ArrayUtil.contains(statuses, -1)) {
            TermsFilter statusesTermsFilter = new TermsFilter("status");
            statusesTermsFilter.addValues(ArrayUtil.toStringArray(statuses));
            contextBooleanFilter.add(statusesTermsFilter, BooleanClauseOccur.MUST);
        } else {
            contextBooleanFilter.addTerm("status", String.valueOf(8), BooleanClauseOccur.MUST_NOT);
        }
    }

    protected BooleanQuery createFullQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        BooleanClause<Query>[] booleanClauses;
        BooleanQueryImpl searchQuery = new BooleanQueryImpl();
        this.addSearchKeywords(searchQuery, searchContext);
        this._addSearchTerms(searchQuery, fullQueryBooleanFilter, searchContext);
        this.doPostProcessSearchQuery(this, searchQuery, searchContext);
        Map<String, Facet> facets = searchContext.getFacets();
        BooleanFilter facetBooleanFilter = new BooleanFilter();
        this.addFacetClause(searchContext, facetBooleanFilter, facets.values());
        if (facetBooleanFilter.hasClauses()) {
            fullQueryBooleanFilter.add(facetBooleanFilter, BooleanClauseOccur.MUST);
        }
        BooleanQueryImpl fullBooleanQuery = new BooleanQueryImpl();
        if (fullQueryBooleanFilter.hasClauses()) {
            fullBooleanQuery.setPreBooleanFilter(fullQueryBooleanFilter);
        }
        if (searchQuery.hasClauses()) {
            fullBooleanQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
            for (BooleanClause<Query> booleanClause : booleanClauses) {
                fullBooleanQuery.add((Query)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
            }
        }
        this.postProcessFullQuery(fullBooleanQuery, searchContext);
        for (IndexerPostProcessor indexerPostProcessor : this._indexerPostProcessors) {
            indexerPostProcessor.postProcessFullQuery(fullBooleanQuery, searchContext);
        }
        return fullBooleanQuery;
    }

    protected Summary createSummary(Document document) {
        return this.createSummary(document, "title", "content");
    }

    protected Summary createSummary(Document document, String titleField, String contentField) {
        String prefix = "snippet_";
        String title = document.get(prefix + titleField, titleField);
        String content = document.get(prefix + contentField, contentField);
        return new Summary(title, content);
    }

    protected void deleteDocument(long companyId, long field1) throws Exception {
        this.deleteDocument(companyId, String.valueOf(field1));
    }

    protected void deleteDocument(long companyId, long field1, String field2) throws Exception {
        this.deleteDocument(companyId, String.valueOf(field1), field2);
    }

    protected void deleteDocument(long companyId, String field1) throws Exception {
        String uid = null;
        if (field1.startsWith("UID=")) {
            uid = field1.substring(4);
        } else {
            DocumentImpl document = new DocumentImpl();
            document.addUID(this.getClassName(), field1);
            uid = document.get("uid");
        }
        IndexWriterHelperUtil.deleteDocument(this.getSearchEngineId(), companyId, uid, this._commitImmediately);
    }

    protected void deleteDocument(long companyId, String field1, String field2) throws Exception {
        DocumentImpl document = new DocumentImpl();
        document.addUID(this.getClassName(), field1, field2);
        IndexWriterHelperUtil.deleteDocument(this.getSearchEngineId(), companyId, document.get("uid"), this._commitImmediately);
    }

    protected abstract void doDelete(T var1) throws Exception;

    protected abstract Document doGetDocument(T var1) throws Exception;

    @Deprecated
    protected String doGetSortField(String orderByCol) {
        return orderByCol;
    }

    protected abstract Summary doGetSummary(Document var1, Locale var2, String var3, PortletRequest var4, PortletResponse var5) throws Exception;

    @Deprecated
    protected void doPostProcessSearchQuery(Indexer<?> indexer, BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        indexer.postProcessSearchQuery(searchQuery, searchContext);
    }

    protected abstract void doReindex(String var1, long var2) throws Exception;

    protected abstract void doReindex(String[] var1) throws Exception;

    protected abstract void doReindex(T var1) throws Exception;

    protected Hits doSearch(SearchContext searchContext) throws SearchException {
        searchContext.setSearchEngineId(this.getSearchEngineId());
        Query fullQuery = this.getFullQuery(searchContext);
        if (!fullQuery.hasChildren()) {
            BooleanFilter preBooleanFilter = fullQuery.getPreBooleanFilter();
            fullQuery = new MatchAllQuery();
            fullQuery.setPreBooleanFilter(preBooleanFilter);
        }
        fullQuery.setQueryConfig(searchContext.getQueryConfig());
        return IndexSearcherHelperUtil.search(searchContext, fullQuery);
    }

    protected Document getBaseModelDocument(String portletId, BaseModel<?> baseModel) {
        return this.getBaseModelDocument(portletId, baseModel, baseModel);
    }

    protected Document getBaseModelDocument(String portletId, BaseModel<?> baseModel, BaseModel<?> workflowedBaseModel) {
        String uuid;
        Map<String, Object> modelAttributes;
        Date displayDate;
        Document document = this.newDocument();
        String className = baseModel.getModelClassName();
        long classPK = 0L;
        long resourcePrimKey = 0L;
        if (baseModel instanceof ResourcedModel) {
            ResourcedModel resourcedModel = (ResourcedModel)((Object)baseModel);
            classPK = resourcedModel.getResourcePrimKey();
            resourcePrimKey = resourcedModel.getResourcePrimKey();
        } else {
            classPK = (Long)baseModel.getPrimaryKeyObj();
        }
        DocumentHelper documentHelper = new DocumentHelper(document);
        documentHelper.setEntryKey(className, classPK);
        document.addUID(className, classPK);
        if (resourcePrimKey > 0L) {
            document.addKeyword("rootEntryClassPK", resourcePrimKey);
        }
        if (workflowedBaseModel instanceof WorkflowedModel) {
            WorkflowedModel workflowedModel = (WorkflowedModel)((Object)workflowedBaseModel);
            document.addKeyword("status", workflowedModel.getStatus());
        }
        if ((displayDate = (Date)(modelAttributes = baseModel.getModelAttributes()).get("displayDate")) != null) {
            document.addDate("displayDate", displayDate);
        }
        if (Validator.isNotNull(uuid = GetterUtil.getString(modelAttributes.get("uuid")))) {
            document.addKeyword("uuid", uuid);
        }
        Iterator<DocumentContributor<?>> iterator = this.getDocumentContributors().iterator();
        while (iterator.hasNext()) {
            DocumentContributor<?> documentContributor;
            DocumentContributor<?> objectDocumentContributor = documentContributor = iterator.next();
            objectDocumentContributor.contribute(document, baseModel);
        }
        return document;
    }

    protected String getClassName(SearchContext searchContext) {
        return this.getClassName();
    }

    protected String[] getDefaultSelectedFieldNames() {
        return this._defaultSelectedFieldNames;
    }

    protected String[] getDefaultSelectedLocalizedFieldNames() {
        return this._defaultSelectedLocalizedFieldNames;
    }

    protected List<DocumentContributor<?>> getDocumentContributors() {
        if (this._documentContributors != null) {
            return this._documentContributors;
        }
        this._documentContributors = ServiceTrackerCollections.openList(DocumentContributor.class);
        return this._documentContributors;
    }

    protected String getExpandoFieldName(SearchContext searchContext, ExpandoBridge expandoBridge, String attributeName) {
        return null;
    }

    protected List<ExpandoQueryContributor> getExpandoQueryContributors() {
        return Collections.singletonList(_expandoQueryContributor);
    }

    protected Locale getLocale(PortletRequest portletRequest) {
        if (portletRequest != null) {
            return portletRequest.getLocale();
        }
        return LocaleUtil.getMostRelevantLocale();
    }

    protected Set<String> getLocalizedCountryNames(Country country) {
        HashSet<String> countryNames = new HashSet<String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String countryName = country.getName(locale);
            countryName = StringUtil.toLowerCase(countryName);
            countryNames.add(countryName);
        }
        return countryNames;
    }

    protected Group getSiteGroup(long groupId) {
        Group group;
        block3: {
            group = null;
            try {
                group = GroupLocalServiceUtil.getGroup(groupId);
                if (group.isLayout()) {
                    group = group.getParentGroup();
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug("Unable to get site group", portalException);
            }
        }
        return group;
    }

    protected long getSiteGroupId(long groupId) {
        Group group = this.getSiteGroup(groupId);
        if (group == null) {
            return groupId;
        }
        return group.getGroupId();
    }

    protected Locale getSnippetLocale(Document document, Locale locale) {
        String prefix = "snippet_";
        String localizedAssetCategoryTitlesName = prefix + Field.getLocalizedName(locale, "assetCategoryTitles");
        String localizedContentName = prefix + Field.getLocalizedName(locale, "content");
        String localizedDescriptionName = prefix + Field.getLocalizedName(locale, "description");
        String localizedTitleName = prefix + Field.getLocalizedName(locale, "title");
        if (document.getField(localizedAssetCategoryTitlesName) != null || document.getField(localizedContentName) != null || document.getField(localizedDescriptionName) != null || document.getField(localizedTitleName) != null) {
            return locale;
        }
        return null;
    }

    protected boolean isStagingGroup(long groupId) {
        Group group = this.getSiteGroup(groupId);
        if (group == null) {
            return false;
        }
        return group.isStagingGroup();
    }

    protected boolean isUseSearchResultPermissionFilter(SearchContext searchContext) {
        return this.isFilterSearch();
    }

    protected boolean isVisible(int entryStatus, int queryStatus) {
        return queryStatus != -1 && entryStatus == queryStatus || entryStatus != 8;
    }

    protected Document newDocument() {
        return (Document)this._document.clone();
    }

    protected void populateAddresses(Document document, List<Address> addresses, long regionId, long countryId) throws PortalException {
        ArrayList<String> regions;
        ArrayList<String> countries;
        ArrayList<String> cities;
        block8: {
            block7: {
                cities = new ArrayList<String>();
                countries = new ArrayList<String>();
                if (countryId > 0L) {
                    try {
                        countries.addAll(this.getLocalizedCountryNames(CountryServiceUtil.getCountry(countryId)));
                    }
                    catch (NoSuchCountryException noSuchCountryException) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn(noSuchCountryException.getMessage());
                    }
                }
            }
            regions = new ArrayList<String>();
            if (regionId > 0L) {
                try {
                    Region region = RegionServiceUtil.getRegion(regionId);
                    regions.add(StringUtil.toLowerCase(region.getName()));
                }
                catch (NoSuchRegionException noSuchRegionException) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn(noSuchRegionException.getMessage());
                }
            }
        }
        ArrayList<String> streets = new ArrayList<String>();
        ArrayList<String> zips = new ArrayList<String>();
        for (Address address : addresses) {
            cities.add(StringUtil.toLowerCase(address.getCity()));
            countries.addAll(this.getLocalizedCountryNames(address.getCountry()));
            Region region = address.getRegion();
            regions.add(StringUtil.toLowerCase(region.getName()));
            streets.add(StringUtil.toLowerCase(address.getStreet1()));
            streets.add(StringUtil.toLowerCase(address.getStreet2()));
            streets.add(StringUtil.toLowerCase(address.getStreet3()));
            zips.add(StringUtil.toLowerCase(address.getZip()));
        }
        document.addText("city", cities.toArray(new String[0]));
        document.addText("country", countries.toArray(new String[0]));
        document.addText("region", regions.toArray(new String[0]));
        document.addText("street", streets.toArray(new String[0]));
        document.addText("zip", zips.toArray(new String[0]));
    }

    protected Map<Locale, String> populateMap(AssetEntry assetEntry, Map<Locale, String> map) {
        return LocalizationUtil.populateLocalizationMap(map, assetEntry.getDefaultLanguageId(), assetEntry.getGroupId());
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
    }

    protected void processHits(SearchContext searchContext, Hits hits) throws SearchException {
        HitsProcessorRegistryUtil.process(searchContext, hits);
    }

    protected void resetFullQuery(SearchContext searchContext) {
        searchContext.clearFullQueryEntryClassNames();
        for (RelatedEntryIndexer relatedEntryIndexer : RelatedEntryIndexerRegistryUtil.getRelatedEntryIndexers()) {
            relatedEntryIndexer.updateFullQuery(searchContext);
        }
    }

    protected void setDefaultSelectedFieldNames(String ... defaultLocalizedFieldNames) {
        this._defaultSelectedFieldNames = defaultLocalizedFieldNames;
    }

    protected void setDefaultSelectedLocalizedFieldNames(String ... defaultLocalizedFieldNames) {
        this._defaultSelectedLocalizedFieldNames = defaultLocalizedFieldNames;
    }

    protected void setFilterSearch(boolean filterSearch) {
        this._filterSearch = filterSearch;
    }

    protected void setPermissionAware(boolean permissionAware) {
        this._permissionAware = permissionAware;
    }

    protected void setStagingAware(boolean stagingAware) {
        this._stagingAware = stagingAware;
    }

    private void _addPreFilters(BooleanFilter queryBooleanFilter, Map<String, Indexer<?>> entryClassNameIndexerMap, SearchContext searchContext) throws Exception {
        _preFilterContributor.contribute(queryBooleanFilter, entryClassNameIndexerMap, searchContext);
    }

    private void _addSearchTerms(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
        for (IndexerPostProcessor indexerPostProcessor : this._indexerPostProcessors) {
            indexerPostProcessor.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
        }
    }

    private Map<String, Indexer<?>> _getEntryClassNameIndexerMap(String[] entryClassNames, String searchEngineId) {
        LinkedHashMap entryClassNameIndexerMap = new LinkedHashMap();
        for (String entryClassName : entryClassNames) {
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer == null || !searchEngineId.equals(indexer.getSearchEngineId())) continue;
            entryClassNameIndexerMap.put(entryClassName, indexer);
        }
        return entryClassNameIndexerMap;
    }
}

