/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.tree;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.TreeModel;
import com.liferay.portal.kernel.tree.TreeModelTasks;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.RecursiveAction;

public class TreePathUtil {
    private static final int _MODEL_TREE_REBUILD_QUERY_RESULTS_BATCH_SIZE = GetterUtil.getInteger(PropsUtil.get("model.tree.rebuild.query.results.batch.size"));

    public static void rebuildTree(long companyId, long parentPrimaryKey, String parentTreePath, TreeModelTasks<?> treeModelTasks) throws PortalException {
        LinkedList<Object[]> traces = new LinkedList<Object[]>();
        traces.push(new Object[]{parentPrimaryKey, parentTreePath, 0L});
        Object[] trace = null;
        while ((trace = (Object[])traces.poll()) != null) {
            Long curParentPrimaryKey = (Long)trace[0];
            String curParentTreePath = (String)trace[1];
            Long previousPrimaryKey = (Long)trace[2];
            treeModelTasks.rebuildDependentModelsTreePaths(curParentPrimaryKey, curParentTreePath);
            List<?> treeModels = treeModelTasks.findTreeModels(previousPrimaryKey, companyId, curParentPrimaryKey, _MODEL_TREE_REBUILD_QUERY_RESULTS_BATCH_SIZE);
            if (treeModels.isEmpty()) continue;
            if (treeModels.size() == _MODEL_TREE_REBUILD_QUERY_RESULTS_BATCH_SIZE) {
                TreeModel treeModel = (TreeModel)treeModels.get(treeModels.size() - 1);
                trace[2] = treeModel.getPrimaryKeyObj();
                traces.push(trace);
            }
            for (TreeModel treeModel : treeModels) {
                String treePath = StringBundler.concat((Object[])new Object[]{curParentTreePath, treeModel.getPrimaryKeyObj(), "/"});
                if (!treePath.equals(treeModel.getTreePath())) {
                    treeModel.updateTreePath(treePath);
                }
                traces.push(new Object[]{treeModel.getPrimaryKeyObj(), treePath, 0L});
            }
        }
    }

    private static class RecursiveRebuildTreeTask
    extends RecursiveAction {
        private final long _companyId;
        private final long _parentPrimaryKey;
        private final String _parentTreePath;
        private final long _previousPrimaryKey;
        private final TreeModelTasks<?> _treeModelTasks;

        @Override
        protected void compute() {
            try {
                this._treeModelTasks.rebuildDependentModelsTreePaths(this._parentPrimaryKey, this._parentTreePath);
            }
            catch (PortalException portalException) {
                ReflectionUtil.throwException((Throwable)portalException);
            }
            List<?> treeModels = this._treeModelTasks.findTreeModels(this._previousPrimaryKey, this._companyId, this._parentPrimaryKey, _MODEL_TREE_REBUILD_QUERY_RESULTS_BATCH_SIZE);
            if (treeModels.isEmpty()) {
                return;
            }
            if (treeModels.size() == _MODEL_TREE_REBUILD_QUERY_RESULTS_BATCH_SIZE) {
                TreeModel treeModel = (TreeModel)treeModels.get(treeModels.size() - 1);
                RecursiveRebuildTreeTask recursiveRebuildTreeTask = new RecursiveRebuildTreeTask(this._treeModelTasks, this._companyId, this._parentPrimaryKey, this._parentTreePath, (Long)treeModel.getPrimaryKeyObj());
                recursiveRebuildTreeTask.fork();
            }
            for (TreeModel treeModel : treeModels) {
                String treePath = StringBundler.concat((Object[])new Object[]{this._parentTreePath, treeModel.getPrimaryKeyObj(), "/"});
                if (!treePath.equals(treeModel.getTreePath())) {
                    treeModel.updateTreePath(treePath);
                }
                RecursiveRebuildTreeTask recursiveRebuildTreeTask = new RecursiveRebuildTreeTask(this._treeModelTasks, this._companyId, (Long)treeModel.getPrimaryKeyObj(), treePath, 0L);
                recursiveRebuildTreeTask.fork();
            }
        }

        private RecursiveRebuildTreeTask(TreeModelTasks<?> treeModelTasks, long companyId, long parentPrimaryKey, String parentTreePath, long previousPrimaryKey) {
            this._treeModelTasks = treeModelTasks;
            this._companyId = companyId;
            this._parentPrimaryKey = parentPrimaryKey;
            this._parentTreePath = parentTreePath;
            this._previousPrimaryKey = previousPrimaryKey;
        }
    }
}

