/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.example.ejb;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class LogSessionBean
implements SessionBean {
    private SessionContext sessionContext;

    public void createLogTable() {
        Connection connection = null;
        Statement statement = null;
        try {
            InitialContext context = new InitialContext();
            DataSource dataSource = (DataSource)context.lookup("java:comp/env/jdbc/MySQLDB");
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            statement.execute("create table logtable(logtime timestamp not null,message char(255) not null)");
        }
        catch (Exception exc) {
            this.sessionContext.setRollbackOnly();
            throw new EJBException(exc.getMessage());
        }
        finally {
            try {
                if (null != statement) {
                    statement.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException sqlExc) {}
        }
    }

    public void logMessage(String message) {
        Connection connection = null;
        Statement statement = null;
        try {
            InitialContext context = new InitialContext();
            DataSource dataSource = (DataSource)context.lookup("java:comp/env/jdbc/MySQLDB");
            connection = dataSource.getConnection();
            statement = connection.prepareStatement("insert into logtable values(?, ?)");
            statement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            statement.setString(2, message);
            statement.executeUpdate();
        }
        catch (Exception exc) {
            this.sessionContext.setRollbackOnly();
            throw new EJBException(exc.getMessage());
        }
        finally {
            try {
                if (null != statement) {
                    statement.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException sqlExc) {}
        }
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void setSessionContext(SessionContext sessionContext) throws EJBException, RemoteException {
        this.sessionContext = sessionContext;
    }
}

