/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.example.ejb;

import com.mockrunner.example.ejb.PaySessionException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class PaySessionBean
implements SessionBean {
    private SessionContext sessionContext;

    public void payBill(String customerId, String billId, double amount) throws PaySessionException {
        Connection connection = null;
        try {
            InitialContext context = new InitialContext();
            DataSource dataSource = (DataSource)context.lookup("java:comp/env/jdbc/MySQLDB");
            connection = dataSource.getConnection();
            String name = this.getName(connection, customerId);
            if (null == name) {
                this.sessionContext.setRollbackOnly();
                throw new PaySessionException(1);
            }
            this.checkBillIntegrity(connection, customerId, billId, amount);
            this.markBillAsPaid(connection, customerId, billId, amount);
            System.out.println(amount + " paid from customer " + name);
        }
        catch (NamingException exc) {
            this.sessionContext.setRollbackOnly();
            throw new EJBException("JNDI error " + exc.getMessage());
        }
        catch (SQLException exc) {
            this.sessionContext.setRollbackOnly();
            throw new EJBException("Database error " + exc.getMessage());
        }
        finally {
            try {
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private String getName(Connection connection, String customerId) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet result = statement.executeQuery("select name from customers where id='" + customerId + "'");
        String name = null;
        if (result.next()) {
            name = result.getString("name");
        }
        result.close();
        statement.close();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBillIntegrity(Connection connection, String customerId, String billId, double amount) throws SQLException, PaySessionException {
        Statement statement = connection.createStatement();
        ResultSet result = statement.executeQuery("select * from openbills where id='" + billId + "'");
        try {
            if (!result.next()) {
                this.sessionContext.setRollbackOnly();
                throw new PaySessionException(2);
            }
            if (!result.getString("customerid").equals(customerId)) {
                this.sessionContext.setRollbackOnly();
                throw new PaySessionException(3);
            }
            if (result.getDouble("amount") != amount) {
                this.sessionContext.setRollbackOnly();
                throw new PaySessionException(4);
            }
        }
        finally {
            result.close();
            statement.close();
        }
    }

    private void markBillAsPaid(Connection connection, String customerId, String billId, double amount) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("delete from openbills where id='" + billId + "'");
        statement.executeUpdate("insert into paidbills values('" + billId + "','" + customerId + "'," + amount + ")");
        statement.close();
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void setSessionContext(SessionContext sessionContext) throws EJBException, RemoteException {
        this.sessionContext = sessionContext;
    }
}

