/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.header.Header;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="format", threadSafe=true)
public final class LicenseFormatMojo
extends AbstractLicenseMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.getLog().info((CharSequence)"Updating license headers...");
        }
        AbstractLicenseMojo.AbstractCallback callback = new AbstractLicenseMojo.AbstractCallback(){

            @Override
            public void onHeaderNotFound(Document document, Header header) {
                document.parseHeader();
                if (document.headerDetected()) {
                    if (LicenseFormatMojo.this.skipExistingHeaders) {
                        LicenseFormatMojo.this.debug("Keeping license header in: %s", document.getFilePath());
                        return;
                    }
                    document.removeHeader();
                }
                LicenseFormatMojo.this.info("Updating license header in: %s", document.getFilePath());
                document.updateHeader(header);
                if (!LicenseFormatMojo.this.dryRun) {
                    document.save();
                } else {
                    String name = document.getFile().getName() + ".licensed";
                    File copy = new File(document.getFile().getParentFile(), name);
                    LicenseFormatMojo.this.info("Result saved to: %s", copy);
                    document.saveTo(copy);
                }
            }

            @Override
            public void onExistingHeader(Document document, Header header) {
                LicenseFormatMojo.this.debug("Header OK in: %s", document.getFilePath());
            }
        };
        this.execute(callback);
        callback.checkUnknown();
    }
}

