/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.retry;

import com.netflix.curator.RetryPolicy;

abstract class SleepingRetry
implements RetryPolicy {
    private final int n;

    protected SleepingRetry(int n) {
        this.n = n;
    }

    public int getN() {
        return this.n;
    }

    @Override
    public boolean allowRetry(int retryCount, long elapsedTimeMs) {
        if (retryCount < this.n) {
            try {
                Thread.sleep(this.getSleepTimeMs(retryCount, elapsedTimeMs));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract int getSleepTimeMs(int var1, long var2);
}

