/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.resolver.AsyncResolver;
import com.netflix.discovery.shared.resolver.ClosableResolver;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.resolver.aws.ApplicationsResolver;
import com.netflix.discovery.shared.resolver.aws.AwsEndpoint;
import com.netflix.discovery.shared.resolver.aws.ConfigClusterResolver;
import com.netflix.discovery.shared.resolver.aws.EurekaHttpResolver;
import com.netflix.discovery.shared.resolver.aws.ZoneAffinityClusterResolver;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpClientFactory;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.decorator.RedirectingEurekaHttpClient;
import com.netflix.discovery.shared.transport.decorator.RetryableEurekaHttpClient;
import com.netflix.discovery.shared.transport.decorator.ServerStatusEvaluators;
import com.netflix.discovery.shared.transport.decorator.SessionedEurekaHttpClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EurekaHttpClients {
    private static final Logger logger = LoggerFactory.getLogger(EurekaHttpClients.class);
    public static final String COMPOSITE_BOOTSTRAP_STRATEGY = "composite";

    private EurekaHttpClients() {
    }

    public static EurekaHttpClientFactory queryClientFactory(ClusterResolver bootstrapResolver, TransportClientFactory transportClientFactory, EurekaClientConfig clientConfig, EurekaTransportConfig transportConfig, InstanceInfo myInstanceInfo, ApplicationsResolver.ApplicationsSource applicationsSource) {
        ClosableResolver<EurekaEndpoint> queryResolver = transportConfig.useBootstrapResolverForQuery() ? EurekaHttpClients.wrapClosable(bootstrapResolver) : EurekaHttpClients.queryClientResolver(bootstrapResolver, transportClientFactory, clientConfig, transportConfig, myInstanceInfo, applicationsSource);
        return EurekaHttpClients.canonicalClientFactory("query", transportConfig, queryResolver, transportClientFactory);
    }

    public static EurekaHttpClientFactory registrationClientFactory(ClusterResolver bootstrapResolver, TransportClientFactory transportClientFactory, EurekaTransportConfig transportConfig) {
        return EurekaHttpClients.canonicalClientFactory("registration", transportConfig, bootstrapResolver, transportClientFactory);
    }

    static EurekaHttpClientFactory canonicalClientFactory(final String name, final EurekaTransportConfig transportConfig, final ClusterResolver<EurekaEndpoint> clusterResolver, final TransportClientFactory transportClientFactory) {
        return new EurekaHttpClientFactory(){

            @Override
            public EurekaHttpClient newClient() {
                return new SessionedEurekaHttpClient(name, RetryableEurekaHttpClient.createFactory(name, transportConfig, clusterResolver, RedirectingEurekaHttpClient.createFactory(transportClientFactory), ServerStatusEvaluators.legacyEvaluator()), transportConfig.getSessionedClientReconnectIntervalSeconds() * 1000);
            }

            @Override
            public void shutdown() {
                EurekaHttpClients.wrapClosable(clusterResolver).shutdown();
            }
        };
    }

    public static ClosableResolver<AwsEndpoint> newBootstrapResolver(EurekaClientConfig clientConfig, EurekaTransportConfig transportConfig, TransportClientFactory transportClientFactory, InstanceInfo myInstanceInfo, ApplicationsResolver.ApplicationsSource applicationsSource) {
        if (COMPOSITE_BOOTSTRAP_STRATEGY.equals(transportConfig.getBootstrapResolverStrategy())) {
            if (clientConfig.shouldFetchRegistry()) {
                return EurekaHttpClients.compositeBootstrapResolver(clientConfig, transportConfig, transportClientFactory, myInstanceInfo, applicationsSource);
            }
            logger.warn("Cannot create a composite bootstrap resolver if registry fetch is disabled. Falling back to using a default bootstrap resolver.");
        }
        return EurekaHttpClients.defaultBootstrapResolver(clientConfig, myInstanceInfo);
    }

    static ClosableResolver<AwsEndpoint> defaultBootstrapResolver(EurekaClientConfig clientConfig, InstanceInfo myInstanceInfo) {
        String[] availZones = clientConfig.getAvailabilityZones(clientConfig.getRegion());
        String myZone = InstanceInfo.getZone(availZones, myInstanceInfo);
        ZoneAffinityClusterResolver delegateResolver = new ZoneAffinityClusterResolver(new ConfigClusterResolver(clientConfig, myInstanceInfo), myZone, true);
        List initialValue = delegateResolver.getClusterEndpoints();
        if (initialValue.isEmpty()) {
            String msg = "Initial resolution of Eureka server endpoints failed. Check ConfigClusterResolver logs for more info";
            logger.error(msg);
            EurekaHttpClients.failFastOnInitCheck(clientConfig, msg);
        }
        return new AsyncResolver<AwsEndpoint>("bootstrap", delegateResolver, initialValue, 1, clientConfig.getEurekaServiceUrlPollIntervalSeconds() * 1000);
    }

    static ClosableResolver<AwsEndpoint> compositeBootstrapResolver(final EurekaClientConfig clientConfig, EurekaTransportConfig transportConfig, TransportClientFactory transportClientFactory, InstanceInfo myInstanceInfo, ApplicationsResolver.ApplicationsSource applicationsSource) {
        ConfigClusterResolver rootResolver = new ConfigClusterResolver(clientConfig, myInstanceInfo);
        final EurekaHttpResolver remoteResolver = new EurekaHttpResolver(clientConfig, transportConfig, rootResolver, transportClientFactory, transportConfig.getWriteClusterVip());
        final ApplicationsResolver localResolver = new ApplicationsResolver(clientConfig, transportConfig, applicationsSource, transportConfig.getWriteClusterVip());
        ClusterResolver<AwsEndpoint> compositeResolver = new ClusterResolver<AwsEndpoint>(){

            @Override
            public String getRegion() {
                return clientConfig.getRegion();
            }

            @Override
            public List<AwsEndpoint> getClusterEndpoints() {
                List<AwsEndpoint> result = localResolver.getClusterEndpoints();
                if (result.isEmpty()) {
                    result = remoteResolver.getClusterEndpoints();
                }
                return result;
            }
        };
        List initialValue = compositeResolver.getClusterEndpoints();
        if (initialValue.isEmpty()) {
            String msg = "Initial resolution of Eureka endpoints failed. Check ConfigClusterResolver logs for more info";
            logger.error(msg);
            EurekaHttpClients.failFastOnInitCheck(clientConfig, msg);
        }
        String[] availZones = clientConfig.getAvailabilityZones(clientConfig.getRegion());
        String myZone = InstanceInfo.getZone(availZones, myInstanceInfo);
        return new AsyncResolver<AwsEndpoint>("bootstrap", new ZoneAffinityClusterResolver(compositeResolver, myZone, true), initialValue, transportConfig.getAsyncExecutorThreadPoolSize(), transportConfig.getAsyncResolverRefreshIntervalMs());
    }

    static ClosableResolver<AwsEndpoint> queryClientResolver(ClusterResolver bootstrapResolver, TransportClientFactory transportClientFactory, EurekaClientConfig clientConfig, EurekaTransportConfig transportConfig, InstanceInfo myInstanceInfo, ApplicationsResolver.ApplicationsSource applicationsSource) {
        EurekaHttpResolver remoteResolver = new EurekaHttpResolver(clientConfig, transportConfig, bootstrapResolver, transportClientFactory, transportConfig.getReadClusterVip());
        ApplicationsResolver localResolver = new ApplicationsResolver(clientConfig, transportConfig, applicationsSource, transportConfig.getReadClusterVip());
        return EurekaHttpClients.compositeQueryResolver(remoteResolver, localResolver, clientConfig, transportConfig, myInstanceInfo);
    }

    static ClosableResolver<AwsEndpoint> compositeQueryResolver(final ClusterResolver<AwsEndpoint> remoteResolver, final ClusterResolver<AwsEndpoint> localResolver, final EurekaClientConfig clientConfig, EurekaTransportConfig transportConfig, InstanceInfo myInstanceInfo) {
        String[] availZones = clientConfig.getAvailabilityZones(clientConfig.getRegion());
        String myZone = InstanceInfo.getZone(availZones, myInstanceInfo);
        ClusterResolver<AwsEndpoint> compositeResolver = new ClusterResolver<AwsEndpoint>(){

            @Override
            public String getRegion() {
                return clientConfig.getRegion();
            }

            @Override
            public List<AwsEndpoint> getClusterEndpoints() {
                List<AwsEndpoint> result = localResolver.getClusterEndpoints();
                if (result.isEmpty()) {
                    result = remoteResolver.getClusterEndpoints();
                }
                return result;
            }
        };
        return new AsyncResolver<AwsEndpoint>("query", new ZoneAffinityClusterResolver(compositeResolver, myZone, true), transportConfig.getAsyncExecutorThreadPoolSize(), transportConfig.getAsyncResolverRefreshIntervalMs(), transportConfig.getAsyncResolverWarmUpTimeoutMs());
    }

    static <T extends EurekaEndpoint> ClosableResolver<T> wrapClosable(final ClusterResolver<T> clusterResolver) {
        if (clusterResolver instanceof ClosableResolver) {
            return (ClosableResolver)clusterResolver;
        }
        return new ClosableResolver<T>(){

            @Override
            public void shutdown() {
            }

            @Override
            public String getRegion() {
                return clusterResolver.getRegion();
            }

            @Override
            public List<T> getClusterEndpoints() {
                return clusterResolver.getClusterEndpoints();
            }
        };
    }

    private static void failFastOnInitCheck(EurekaClientConfig clientConfig, String msg) {
        if ("true".equals(clientConfig.getExperimental("clientTransportFailFastOnInit"))) {
            throw new RuntimeException(msg);
        }
    }
}

