/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticFeature
class JavaLangSubstitutionsJDK9OrLaterFeature
implements Feature {
    JavaLangSubstitutionsJDK9OrLaterFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return !JavaVersionUtil.Java8OrEarlier;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        Class processHandleImplClass = access.findClassByName("java.lang.ProcessHandleImpl");
        VMError.guarantee(processHandleImplClass != null);
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(processHandleImplClass, "for substitutions");
    }
}

