/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.NativeImagePatcher;
import com.oracle.svm.core.heap.ReferenceAccess;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.word.Pointer;

public class AMD64NativeImagePatcher
extends CompilationResult.CodeAnnotation
implements NativeImagePatcher {
    private final AMD64BaseAssembler.OperandDataAnnotation annotation;

    public AMD64NativeImagePatcher(int instructionStartPosition, AMD64BaseAssembler.OperandDataAnnotation annotation) {
        super(instructionStartPosition);
        this.annotation = annotation;
    }

    @Override
    public void patch(int codePos, int relative, byte[] code) {
        int curValue = relative - (this.annotation.nextInstructionPosition - this.annotation.instructionPosition);
        for (int i = 0; i < this.annotation.operandSize; ++i) {
            assert (code[this.annotation.operandPosition + i] == 0);
            code[this.annotation.operandPosition + i] = (byte)(curValue & 0xFF);
            curValue >>>= 8;
        }
        assert (curValue == 0);
    }

    @Override
    @Uninterruptible(reason="The patcher is intended to work with raw pointers")
    public void patchData(Pointer pointer, Object object) {
        Pointer address = pointer.add(this.annotation.operandPosition);
        if (this.annotation.operandSize == 8 && this.annotation.operandSize > ConfigurationValues.getObjectLayout().getReferenceSize()) {
            address.writeLong(0, 0L);
        } else assert (this.annotation.operandSize == ConfigurationValues.getObjectLayout().getReferenceSize()) : "Unsupported reference constant size";
        boolean compressed = ReferenceAccess.singleton().haveCompressedReferences();
        ReferenceAccess.singleton().writeObjectAt(address, object, compressed);
    }

    @Override
    public int getPosition() {
        return this.annotation.operandPosition;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }
}

