/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.meta.CompressibleConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class SubstrateObjectConstant
implements JavaConstant,
CompressibleConstant,
VMConstant {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final AtomicReferenceFieldUpdater<SubstrateObjectConstant, Object> ROOT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SubstrateObjectConstant.class, Object.class, "root");
    private final Object object;
    private final boolean compressed;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private volatile Object root;

    public static JavaConstant forObject(Object object) {
        return SubstrateObjectConstant.forObject(object, false);
    }

    public static JavaConstant forObject(Object object, boolean compressed) {
        if (object == null) {
            return compressed ? CompressedNullConstant.COMPRESSED_NULL : JavaConstant.NULL_POINTER;
        }
        return new SubstrateObjectConstant(object, compressed);
    }

    public static JavaConstant forBoxedValue(JavaKind kind, Object value) {
        if (kind == JavaKind.Object) {
            return SubstrateObjectConstant.forObject(value);
        }
        return JavaConstant.forBoxedPrimitive((Object)value);
    }

    public static Object asObject(Constant constant) {
        if (JavaConstant.isNull((Constant)constant)) {
            return null;
        }
        return ((SubstrateObjectConstant)constant).object;
    }

    public static <T> T asObject(Class<T> type, JavaConstant constant) {
        Object object;
        if (constant.isNonNull() && type.isInstance(object = ((SubstrateObjectConstant)constant).object)) {
            return type.cast(object);
        }
        return null;
    }

    public static Object asObject(ResolvedJavaType type, JavaConstant constant) {
        if (constant.isNonNull() && constant instanceof SubstrateObjectConstant) {
            Object object = ((SubstrateObjectConstant)constant).object;
            if (type.isInstance(constant)) {
                return object;
            }
        }
        return null;
    }

    public static boolean isCompressed(JavaConstant constant) {
        return constant instanceof CompressibleConstant && ((CompressibleConstant)constant).isCompressed();
    }

    private SubstrateObjectConstant(Object object, boolean compressed) {
        this.object = object;
        this.compressed = compressed;
        assert (object != null);
        if (SubstrateUtil.isInLibgraal()) {
            throw new InternalError();
        }
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    public JavaConstant compress() {
        assert (!this.compressed);
        return new SubstrateObjectConstant(this.object, true);
    }

    public JavaConstant uncompress() {
        assert (this.compressed);
        return new SubstrateObjectConstant(this.object, false);
    }

    public boolean setRoot(Object newRoot) {
        if (this.root == null && newRoot != null) {
            return ROOT_UPDATER.compareAndSet(this, null, newRoot);
        }
        return false;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isDefaultForKind() {
        return false;
    }

    public Object asBoxedPrimitive() {
        throw new IllegalArgumentException();
    }

    public int asInt() {
        throw new IllegalArgumentException();
    }

    public boolean asBoolean() {
        throw new IllegalArgumentException();
    }

    public long asLong() {
        throw new IllegalArgumentException();
    }

    public float asFloat() {
        throw new IllegalArgumentException();
    }

    public double asDouble() {
        throw new IllegalArgumentException();
    }

    public int hashCode() {
        return System.identityHashCode(this.object);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubstrateObjectConstant) {
            SubstrateObjectConstant other = (SubstrateObjectConstant)o;
            if (this.object == other.object && this.compressed == other.compressed) {
                return true;
            }
        }
        return false;
    }

    public String toValueString() {
        Object obj = KnownIntrinsics.convertUnknownValue(this.object, Object.class);
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.getClass().getName();
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public String toString() {
        return this.getJavaKind().getJavaName();
    }
}

