/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;

public class JavadocParagraphCheck
extends AbstractJavadocCheck {
    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{6, 10001};
    }

    @Override
    public void visitJavadocToken(DetailNode aAst) {
        if (aAst.getType() == 6 && this.isEmptyLine(aAst)) {
            this.checkEmptyLine(aAst);
        } else if (aAst.getType() == 10001 && JavadocUtils.getFirstChild(aAst).getType() == 10006) {
            this.checkParagraphTag(aAst);
        }
    }

    private void checkEmptyLine(DetailNode aNewline) {
        DetailNode nearestToken = this.getNearestNode(aNewline);
        if (!this.isLastEmptyLine(aNewline) && nearestToken != null && nearestToken.getType() == 10074 && nearestToken.getChildren().length > 1) {
            this.log(aNewline.getLineNumber(), "javadoc.paragraph.tag.after", new Object[0]);
        }
    }

    private void checkParagraphTag(DetailNode aTag) {
        DetailNode newLine = this.getNearestEmptyLine(aTag);
        if (this.isFirstParagraph(aTag)) {
            this.log(aTag.getLineNumber(), "javadoc.paragraph.redundant.paragraph", new Object[0]);
        } else if (newLine == null || aTag.getLineNumber() - newLine.getLineNumber() != 1) {
            this.log(aTag.getLineNumber(), "javadoc.paragraph.line.before", new Object[0]);
        }
    }

    private DetailNode getNearestNode(DetailNode aNode) {
        DetailNode tag = JavadocUtils.getNextSibling(aNode);
        while (tag != null && (tag.getType() == 1 || tag.getType() == 6)) {
            tag = JavadocUtils.getNextSibling(tag);
        }
        return tag;
    }

    private boolean isEmptyLine(DetailNode aNewLine) {
        DetailNode previousSibling = JavadocUtils.getPreviousSibling(aNewLine);
        if (previousSibling == null || previousSibling.getParent().getType() != 10000) {
            return false;
        }
        if (previousSibling.getType() == 10074 && previousSibling.getChildren().length == 1) {
            previousSibling = JavadocUtils.getPreviousSibling(previousSibling);
        }
        return previousSibling != null && previousSibling.getType() == 1;
    }

    private boolean isFirstParagraph(DetailNode aParagraphTag) {
        DetailNode previousNode = JavadocUtils.getPreviousSibling(aParagraphTag);
        while (previousNode != null) {
            if (previousNode.getType() == 10074 && previousNode.getChildren().length > 1 || previousNode.getType() != 1 && previousNode.getType() != 6 && previousNode.getType() != 10074) {
                return false;
            }
            previousNode = JavadocUtils.getPreviousSibling(previousNode);
        }
        return true;
    }

    private DetailNode getNearestEmptyLine(DetailNode aNode) {
        DetailNode newLine = JavadocUtils.getPreviousSibling(aNode);
        while (newLine != null) {
            DetailNode previousSibling = JavadocUtils.getPreviousSibling(newLine);
            if (newLine.getType() == 6 && this.isEmptyLine(newLine)) break;
            newLine = previousSibling;
        }
        return newLine;
    }

    private boolean isLastEmptyLine(DetailNode aNewLine) {
        DetailNode nextNode = JavadocUtils.getNextSibling(aNewLine);
        while (nextNode != null && nextNode.getType() != 10071) {
            if (nextNode.getType() == 10074 && nextNode.getChildren().length > 1 || nextNode.getType() == 10001) {
                return false;
            }
            nextNode = JavadocUtils.getNextSibling(nextNode);
        }
        return true;
    }
}

