/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractAccessControlNameCheck;

public class MethodNameCheck
extends AbstractAccessControlNameCheck {
    private boolean mAllowClassName;

    public MethodNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    public void visitToken(DetailAST aAst) {
        super.visitToken(aAst);
        if (!this.mAllowClassName) {
            DetailAST method = aAst.findFirstToken(59);
            DetailAST classDefOrNew = aAst.getParent().getParent();
            DetailAST classIdent = classDefOrNew.findFirstToken(59);
            if (null != classIdent && method.getText().equals(classIdent.getText())) {
                this.log(method.getLineNo(), method.getColumnNo(), "method.name.equals.class.name", method.getText());
            }
        }
    }

    public void setAllowClassName(boolean aAllowClassName) {
        this.mAllowClassName = aAllowClassName;
    }
}

