/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@StatelessCheck
public class SummaryJavadocCheck
extends AbstractJavadocCheck {
    public static final String MSG_SUMMARY_FIRST_SENTENCE = "summary.first.sentence";
    public static final String MSG_SUMMARY_JAVADOC = "summary.javaDoc";
    public static final String MSG_SUMMARY_JAVADOC_MISSING = "summary.javaDoc.missing";
    public static final String MSG_SUMMARY_MISSING_PERIOD = "summary.javaDoc.missing.period";
    private static final Pattern JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN = Pattern.compile("\n[ ]+(\\*)|^[ ]+(\\*)");
    private static final Pattern HTML_ELEMENTS = Pattern.compile("<[^>]*>");
    private static final Pattern SUMMARY_PATTERN = Pattern.compile("\\{@summary ([\\S\\s]+)}");
    private static final String PERIOD = ".";
    private static final String SUMMARY_TEXT = "@summary";
    private static final Set<Integer> ALLOWED_TYPES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(4, 10068, 10074)));
    private Pattern forbiddenSummaryFragments = CommonUtil.createPattern("^$");
    private String period = ".";

    public void setForbiddenSummaryFragments(Pattern pattern) {
        this.forbiddenSummaryFragments = pattern;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (SummaryJavadocCheck.containsSummaryTag(ast)) {
            this.validateSummaryTag(ast);
        } else if (!SummaryJavadocCheck.startsWithInheritDoc(ast)) {
            String summaryDoc = SummaryJavadocCheck.getSummarySentence(ast);
            if (summaryDoc.isEmpty()) {
                this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC_MISSING, new Object[0]);
            } else if (!this.period.isEmpty()) {
                String firstSentence = SummaryJavadocCheck.getFirstSentence(ast);
                int endOfSentence = firstSentence.lastIndexOf(this.period);
                if (!summaryDoc.contains(this.period)) {
                    this.log(ast.getLineNumber(), MSG_SUMMARY_FIRST_SENTENCE, new Object[0]);
                }
                if (endOfSentence != -1 && this.containsForbiddenFragment(firstSentence.substring(0, endOfSentence))) {
                    this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC, new Object[0]);
                }
            }
        }
    }

    private static boolean containsSummaryTag(DetailNode javadoc) {
        Optional<DetailNode> node = Arrays.stream(javadoc.getChildren()).filter(SummaryJavadocCheck::isInlineTagPresent).findFirst().map(SummaryJavadocCheck::getInlineTagNodeWithinHtmlElement);
        return node.isPresent() && SummaryJavadocCheck.isSummaryTag(node.get());
    }

    private static boolean isInlineTagPresent(DetailNode ast) {
        return ast.getType() == 10072 || ast.getType() == 10001 && SummaryJavadocCheck.getInlineTagNodeWithinHtmlElement(ast) != null;
    }

    private static DetailNode getInlineTagNodeWithinHtmlElement(DetailNode ast) {
        DetailNode node = ast;
        DetailNode result = null;
        if (node.getType() == 10072) {
            result = node;
        } else if (node.getType() == 10005) {
            node = node.getChildren()[1];
            result = SummaryJavadocCheck.getInlineTagNodeWithinHtmlElement(node);
        } else if (node.getType() == 10001 && node.getChildren()[0].getChildren().length > 1) {
            node = node.getChildren()[0].getChildren()[1];
            result = SummaryJavadocCheck.getInlineTagNodeWithinHtmlElement(node);
        }
        return result;
    }

    private static boolean isSummaryTag(DetailNode javadoc) {
        DetailNode[] child = javadoc.getChildren();
        return child[1].getType() == 21 && SUMMARY_TEXT.equals(child[1].getText());
    }

    private void validateSummaryTag(DetailNode ast) {
        String inlineSummary = this.getInlineSummary();
        String summaryVisible = SummaryJavadocCheck.getVisibleContent(inlineSummary);
        if (summaryVisible.isEmpty()) {
            this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC_MISSING, new Object[0]);
        } else if (!this.period.isEmpty()) {
            if (SummaryJavadocCheck.isPeriodAtEnd(summaryVisible, this.period)) {
                this.log(ast.getLineNumber(), MSG_SUMMARY_MISSING_PERIOD, new Object[0]);
            } else if (this.containsForbiddenFragment(inlineSummary)) {
                this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC, new Object[0]);
            }
        }
    }

    private String getInlineSummary() {
        DetailAST blockCommentAst = this.getBlockCommentAst();
        String javadocText = blockCommentAst.getFirstChild().getText();
        Matcher matcher = SUMMARY_PATTERN.matcher(javadocText);
        String comment = "";
        if (matcher.find()) {
            comment = matcher.group(1);
        }
        comment = JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN.matcher(comment).replaceAll("");
        return comment;
    }

    private static String getVisibleContent(String summary) {
        String visibleSummary = HTML_ELEMENTS.matcher(summary).replaceAll("");
        return visibleSummary.trim();
    }

    private static boolean isPeriodAtEnd(String sentence, String period) {
        String summarySentence = sentence.trim();
        return summarySentence.lastIndexOf(period) != summarySentence.length() - 1;
    }

    private boolean containsForbiddenFragment(String firstSentence) {
        String javadocText = JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN.matcher(firstSentence).replaceAll(" ").trim();
        return this.forbiddenSummaryFragments.matcher(SummaryJavadocCheck.trimExcessWhitespaces(javadocText)).find();
    }

    private static String trimExcessWhitespaces(String text) {
        StringBuilder result = new StringBuilder(256);
        boolean previousWhitespace = true;
        for (char letter : text.toCharArray()) {
            char print;
            if (Character.isWhitespace(letter)) {
                if (previousWhitespace) continue;
                previousWhitespace = true;
                print = ' ';
            } else {
                previousWhitespace = false;
                print = letter;
            }
            result.append(print);
        }
        return result.toString();
    }

    private static boolean startsWithInheritDoc(DetailNode root) {
        boolean found = false;
        DetailNode[] children = root.getChildren();
        int i = 0;
        while (!found) {
            DetailNode child = children[i];
            if (child.getType() == 10072 && child.getChildren()[1].getType() == 47) {
                found = true;
            } else if (child.getType() != 1 && !CommonUtil.isBlank(child.getText())) break;
            ++i;
        }
        return found;
    }

    private static String getSummarySentence(DetailNode ast) {
        boolean flag = true;
        StringBuilder result = new StringBuilder(256);
        for (DetailNode child : ast.getChildren()) {
            if (ALLOWED_TYPES.contains(child.getType())) {
                result.append(child.getText());
            } else if (child.getType() == 10001 && CommonUtil.isBlank(result.toString().trim())) {
                result.append(SummaryJavadocCheck.getStringInsideTag(result.toString(), child.getChildren()[0].getChildren()[0]));
            } else if (child.getType() == 10071) {
                flag = false;
            }
            if (!flag) break;
        }
        return result.toString().trim();
    }

    private static String getStringInsideTag(String result, DetailNode detailNode) {
        StringBuilder contents = new StringBuilder(result);
        DetailNode tempNode = detailNode;
        while (tempNode != null) {
            if (tempNode.getType() == 10074) {
                contents.append(tempNode.getText());
            }
            tempNode = JavadocUtil.getNextSibling(tempNode);
        }
        return contents.toString();
    }

    private static String getFirstSentence(DetailNode ast) {
        StringBuilder result = new StringBuilder(256);
        String periodSuffix = ". ";
        for (DetailNode child : ast.getChildren()) {
            String text = child.getChildren().length == 0 ? child.getText() : SummaryJavadocCheck.getFirstSentence(child);
            if (text.contains(". ")) {
                result.append(text, 0, text.indexOf(". ") + 1);
                break;
            }
            result.append(text);
        }
        return result.toString();
    }
}

