/*
 * Decompiled with CFR 0.152.
 */
package org.nico.noson.cache;

import org.nico.noson.cache.Cache;
import org.nico.noson.cache.SimpleCache;

public class CacheManager {
    private static ThreadLocal<Cache> localKeyCaches = new ThreadLocal();
    private static ThreadLocal<Cache> localValueCaches = new ThreadLocal();
    private static ThreadLocal<Cache> localClassProxyCaches = new ThreadLocal();
    private static ThreadLocal<Cache> localFieldTypeCaches = new ThreadLocal();
    private static ThreadLocal<Cache> localFieldCaches = new ThreadLocal();

    public static Cache getKeyCache() {
        Cache cache = localKeyCaches.get();
        if (cache == null) {
            cache = new SimpleCache();
            localKeyCaches.set(new SimpleCache());
        }
        return cache;
    }

    public static Cache getValueCache() {
        Cache cache = localValueCaches.get();
        if (cache == null) {
            cache = new SimpleCache();
            localValueCaches.set(new SimpleCache());
        }
        return cache;
    }

    public static Cache getClassProxyCache() {
        Cache cache = localClassProxyCaches.get();
        if (cache == null) {
            cache = new SimpleCache();
            localClassProxyCaches.set(new SimpleCache());
        }
        return cache;
    }

    public static Cache getFieldTypeCache() {
        Cache cache = localFieldTypeCaches.get();
        if (cache == null) {
            cache = new SimpleCache();
            localFieldTypeCaches.set(new SimpleCache());
        }
        return cache;
    }

    public static Cache getFieldCache() {
        Cache cache = localFieldCaches.get();
        if (cache == null) {
            cache = new SimpleCache();
            localFieldCaches.set(new SimpleCache());
        }
        return cache;
    }

    public static void clearLocalCache() {
        Cache cache = localKeyCaches.get();
        if (cache != null) {
            cache.clearCache();
        }
        if ((cache = localValueCaches.get()) != null) {
            cache.clearCache();
        }
        if ((cache = localClassProxyCaches.get()) != null) {
            cache.clearCache();
        }
        if ((cache = localFieldTypeCaches.get()) != null) {
            cache.clearCache();
        }
        if ((cache = localFieldCaches.get()) != null) {
            cache.clearCache();
        }
    }
}

