/*
 * Decompiled with CFR 0.152.
 */
package org.nico.noson.verify;

public class SymbolVerify {
    private int brace = 0;
    private int bracket = 0;
    private int singleQuote = 0;
    private int doubleQuote = 0;
    private int colon = 0;
    private int temp = 0;
    private char preChar = '\u0000';

    public boolean safetyAll() {
        return this.brace == 0 && this.bracket == 0 && this.singleQuote == 0 && this.doubleQuote == 0 && this.temp == 0;
    }

    public boolean safetyQuote() {
        return this.singleQuote == 0 && this.doubleQuote == 0;
    }

    public boolean safetyBrace() {
        return this.brace == 0;
    }

    public boolean safetyBracket() {
        return this.bracket == 0;
    }

    public boolean safetySingleQuote() {
        return this.singleQuote == 0;
    }

    public boolean safetyDoubleQuote() {
        return this.doubleQuote == 0;
    }

    public boolean turnValue() {
        return this.colon == 1;
    }

    public boolean verify(char target) {
        int sum = this.brace + this.bracket + this.singleQuote + this.doubleQuote;
        switch (target) {
            case '{': {
                ++this.brace;
                break;
            }
            case '}': {
                --this.brace;
                break;
            }
            case '[': {
                ++this.bracket;
                break;
            }
            case ']': {
                --this.bracket;
                break;
            }
            case '\'': {
                if (this.preChar == '\\' || this.doubleQuote != 0) break;
                this.temp = this.singleQuote == 1 ? (this.singleQuote = this.singleQuote - 1) : (this.singleQuote = this.singleQuote + 1);
                break;
            }
            case '\"': {
                if (this.preChar == '\\' || this.singleQuote != 0) break;
                this.temp = this.doubleQuote == 1 ? (this.doubleQuote = this.doubleQuote - 1) : (this.doubleQuote = this.doubleQuote + 1);
                break;
            }
            case ':': {
                if (this.singleQuote + this.doubleQuote != 0) break;
                this.colon = 1;
            }
        }
        this.preChar = target;
        return sum != this.brace + this.bracket + this.singleQuote + this.doubleQuote;
    }

    public boolean check(String json) {
        char[] chars;
        for (char ch : chars = json.toCharArray()) {
            this.verify(ch);
        }
        return this.safetyAll();
    }

    public boolean isSpecial(char c) {
        if (this.singleQuote + this.doubleQuote != 0) {
            return false;
        }
        return c == ':';
    }

    public int getBrace() {
        return this.brace;
    }

    public void setBrace(int brace) {
        this.brace = brace;
    }

    public int getBracket() {
        return this.bracket;
    }

    public void setBracket(int bracket) {
        this.bracket = bracket;
    }

    public int getSingleQuote() {
        return this.singleQuote;
    }

    public void setSingleQuote(int singleQuote) {
        this.singleQuote = singleQuote;
    }

    public int getDoubleQuote() {
        return this.doubleQuote;
    }

    public void setDoubleQuote(int doubleQuote) {
        this.doubleQuote = doubleQuote;
    }

    public int getColon() {
        return this.colon;
    }

    public void setColon(int colon) {
        this.colon = colon;
    }
}

