/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerCertificatesStore;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.messages.RegistryAuth;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

abstract class AbstractDockerMojo
extends AbstractMojo {
    @Component(role=MavenSession.class)
    protected MavenSession session;
    @Component(role=MojoExecution.class)
    protected MojoExecution execution;
    @Component
    private Settings settings;
    @Component(role=SecDispatcher.class, hint="mng-4384")
    private SecDispatcher secDispatcher;
    @Parameter(property="dockerHost")
    private String dockerHost;
    @Parameter(property="dockerCertPath")
    private String dockerCertPath;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="registryUrl")
    private String registryUrl;
    @Parameter(property="useConfigFile")
    private Boolean useConfigFile;
    @Parameter(property="retryPushCount", defaultValue="5")
    private int retryPushCount;
    @Parameter(property="retryPushTimeout", defaultValue="10000")
    private int retryPushTimeout;
    @Parameter(property="skipDocker", defaultValue="false")
    private boolean skipDocker;
    @Parameter(property="skipDockerPush", defaultValue="false")
    private boolean skipDockerPush;

    AbstractDockerMojo() {
    }

    public int getRetryPushTimeout() {
        return this.retryPushTimeout;
    }

    public int getRetryPushCount() {
        return this.retryPushCount;
    }

    public boolean isSkipDocker() {
        return this.skipDocker;
    }

    public boolean isSkipDockerPush() {
        return this.skipDockerPush;
    }

    public void execute() throws MojoExecutionException {
        if (this.skipDocker) {
            this.getLog().info((CharSequence)"Skipping docker goal");
            return;
        }
        try (DockerClient client = this.buildDockerClient();){
            this.execute(client);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception caught", e);
        }
    }

    protected DefaultDockerClient.Builder getBuilder() throws DockerCertificateException {
        return DefaultDockerClient.fromEnv().readTimeoutMillis(0L);
    }

    protected DockerClient buildDockerClient() throws DockerCertificateException, SecDispatcherException, MojoExecutionException {
        RegistryAuth registryAuth;
        Optional<DockerCertificatesStore> certs;
        DefaultDockerClient.Builder builder = this.getBuilder();
        String dockerHost = this.rawDockerHost();
        if (!Strings.isNullOrEmpty((String)dockerHost)) {
            builder.uri(dockerHost);
        }
        if ((certs = this.dockerCertificates()).isPresent()) {
            builder.dockerCertificates((DockerCertificatesStore)certs.get());
        }
        if ((registryAuth = this.registryAuth()) != null) {
            builder.registryAuth(registryAuth);
        }
        return builder.build();
    }

    protected abstract void execute(DockerClient var1) throws Exception;

    protected String rawDockerHost() {
        return this.dockerHost;
    }

    protected Optional<DockerCertificatesStore> dockerCertificates() throws DockerCertificateException {
        if (!Strings.isNullOrEmpty((String)this.dockerCertPath)) {
            return DockerCertificates.builder().dockerCertPath(Paths.get(this.dockerCertPath, new String[0])).build();
        }
        return Optional.absent();
    }

    private String getEmail(Server server) {
        Xpp3Dom emailNode;
        String email = null;
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        if (configuration != null && (emailNode = configuration.getChild("email")) != null) {
            email = emailNode.getValue();
        }
        return email;
    }

    private boolean incompleteAuthSettings(String username, String password, String email) {
        return !(Strings.isNullOrEmpty((String)username) && Strings.isNullOrEmpty((String)password) && Strings.isNullOrEmpty((String)email) || !Strings.isNullOrEmpty((String)username) && !Strings.isNullOrEmpty((String)password) && !Strings.isNullOrEmpty((String)email));
    }

    protected RegistryAuth registryAuth() throws MojoExecutionException, SecDispatcherException {
        if (this.settings != null) {
            Server server = this.settings.getServer(this.serverId);
            if (server != null) {
                String email;
                RegistryAuth.Builder registryAuthBuilder = RegistryAuth.builder();
                String username = server.getUsername();
                String password = server.getPassword();
                if (this.secDispatcher != null) {
                    password = this.secDispatcher.decrypt(password);
                }
                if (this.incompleteAuthSettings(username, password, email = this.getEmail(server))) {
                    throw new MojoExecutionException("Incomplete Docker registry authorization credentials. Please provide all of username, password, and email or none.");
                }
                if (!Strings.isNullOrEmpty((String)username)) {
                    registryAuthBuilder.username(username);
                }
                if (!Strings.isNullOrEmpty((String)email)) {
                    registryAuthBuilder.email(email);
                }
                if (!Strings.isNullOrEmpty((String)password)) {
                    registryAuthBuilder.password(password);
                }
                if (!Strings.isNullOrEmpty((String)this.registryUrl)) {
                    registryAuthBuilder.serverAddress(this.registryUrl);
                }
                return registryAuthBuilder.build();
            }
            if (this.useConfigFile != null && this.useConfigFile.booleanValue()) {
                RegistryAuth.Builder registryAuthBuilder;
                try {
                    registryAuthBuilder = !Strings.isNullOrEmpty((String)this.registryUrl) ? RegistryAuth.fromDockerConfig((String)this.registryUrl) : RegistryAuth.fromDockerConfig();
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Docker config file could not be read", (Exception)ex);
                }
                return registryAuthBuilder.build();
            }
        }
        return null;
    }
}

