/*
 * Decompiled with CFR 0.152.
 */
package com.spring4all.spring.boot.starter.hbase.boot;

import com.spring4all.spring.boot.starter.hbase.api.HBaseTemplate;
import com.spring4all.spring.boot.starter.hbase.boot.HBaseProperties;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={HBaseProperties.class})
@ConditionalOnClass(value={HBaseTemplate.class})
public class HBaseAutoConfiguration {
    private static final String HBASE_QUORUM = "hbase.zookeeper.quorum";
    private static final String HBASE_ROOTDIR = "hbase.rootdir";
    private static final String HBASE_ZNODE_PARENT = "zookeeper.znode.parent";
    @Autowired
    private HBaseProperties hbaseProperties;

    @Bean
    @ConditionalOnMissingBean(value={HBaseTemplate.class})
    public HBaseTemplate hbaseTemplate() {
        org.apache.hadoop.conf.Configuration configuration = HBaseConfiguration.create();
        configuration.set(HBASE_QUORUM, this.hbaseProperties.getQuorum());
        configuration.set(HBASE_ROOTDIR, this.hbaseProperties.getRootDir());
        configuration.set(HBASE_ZNODE_PARENT, this.hbaseProperties.getNodeParent());
        return new HBaseTemplate(configuration);
    }
}

