/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.renderers;

import com.taobao.text.LineRenderer;
import com.taobao.text.Renderer;
import com.taobao.text.ui.Overflow;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.Utils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class FileRenderer
extends Renderer<File> {
    @Override
    public Class<File> getType() {
        return File.class;
    }

    @Override
    public LineRenderer renderer(Iterator<File> stream) {
        List<File> files = Utils.list(stream);
        Collections.sort(files);
        TableElement table = new TableElement().overflow(Overflow.WRAP).rightCellPadding(1);
        SimpleDateFormat format = new SimpleDateFormat("MMM dd HH:mm");
        Date date = new Date();
        for (File file : files) {
            String mode = (file.isDirectory() ? "d" : "-") + (file.canRead() ? "r" : "-") + (file.canWrite() ? "w" : "-") + (file.canExecute() ? "x" : "-");
            String length = Long.toString(file.length());
            date.setTime(file.lastModified());
            String lastModified = format.format(date);
            table.row(mode, length, lastModified, file.getName());
        }
        return table.renderer();
    }
}

