/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.ui;

import com.taobao.text.LineReader;
import com.taobao.text.LineRenderer;
import com.taobao.text.RenderAppendable;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TreeElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class TreeLineRenderer
extends LineRenderer {
    private final LineRenderer value;
    private final List<LineRenderer> children;

    TreeLineRenderer(TreeElement tree) {
        ArrayList<LineRenderer> children = new ArrayList<LineRenderer>(tree.children.size());
        for (Element child : tree.children) {
            children.add(child.renderer());
        }
        this.children = children;
        this.value = tree.value != null ? tree.value.renderer() : null;
    }

    @Override
    public int getActualWidth() {
        int width = this.value != null ? this.value.getActualWidth() : 0;
        for (LineRenderer child : this.children) {
            width = Math.max(width, 2 + child.getActualWidth());
        }
        return width;
    }

    @Override
    public int getMinWidth() {
        int width = this.value != null ? this.value.getMinWidth() : 0;
        for (LineRenderer child : this.children) {
            width = Math.max(width, 2 + child.getMinWidth());
        }
        return width;
    }

    @Override
    public int getActualHeight(int width) {
        throw new UnsupportedOperationException("Implement me");
    }

    @Override
    public int getMinHeight(int width) {
        throw new UnsupportedOperationException("Implement me");
    }

    @Override
    public LineReader reader(final int width) {
        final LinkedList<LineReader> readers = new LinkedList<LineReader>();
        for (LineRenderer child : this.children) {
            readers.addLast(child.reader(width - 2));
        }
        return new LineReader(){
            LineReader value;
            boolean node;
            {
                this.value = TreeLineRenderer.this.value != null ? TreeLineRenderer.this.value.reader(width) : null;
                this.node = true;
            }

            @Override
            public boolean hasLine() {
                if (this.value != null) {
                    if (this.value.hasLine()) {
                        return true;
                    }
                    this.value = null;
                }
                while (readers.size() > 0) {
                    if (((LineReader)readers.peekFirst()).hasLine()) {
                        return true;
                    }
                    readers.removeFirst();
                    this.node = true;
                }
                return false;
            }

            @Override
            public void renderLine(RenderAppendable to) {
                if (this.value != null) {
                    if (this.value.hasLine()) {
                        this.value.renderLine(to);
                    } else {
                        this.value = null;
                    }
                }
                if (this.value == null) {
                    while (readers.size() > 0) {
                        LineReader first = (LineReader)readers.peekFirst();
                        if (!first.hasLine()) continue;
                        if (this.node) {
                            to.append("+-");
                            this.node = false;
                        } else {
                            Iterator i = readers.descendingIterator();
                            boolean rest = false;
                            while (i.hasNext()) {
                                LineReader renderer = (LineReader)i.next();
                                if (!i.hasNext() || !renderer.hasLine()) continue;
                                rest = true;
                                break;
                            }
                            if (rest) {
                                to.append("| ");
                            } else {
                                to.append("  ");
                            }
                        }
                        first.renderLine(to);
                        break;
                    }
                }
            }
        };
    }
}

