/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBResultSetRowData;
import com.taosdata.jdbc.TaosGlobalConfig;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;

public class TSDBJNIConnector {
    static final long INVALID_CONNECTION_POINTER_VALUE = 0L;
    static volatile Boolean isInitialized = false;
    private long taos = 0L;
    private boolean isResultsetClosed = true;
    private int affectedRows = -1;

    public boolean isClosed() {
        return this.taos == 0L;
    }

    public boolean isResultsetClosed() {
        return this.isResultsetClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String configDir, String locale, String charset, String timezone) throws SQLWarning {
        Boolean bl = isInitialized;
        synchronized (bl) {
            if (!isInitialized.booleanValue()) {
                TSDBJNIConnector.initImp(configDir);
                if (TSDBJNIConnector.setOptions(0, locale) < 0) {
                    throw new SQLWarning(TSDBConstants.WrapErrMsg("Failed to set locale: " + locale + ". System default will be used."));
                }
                if (TSDBJNIConnector.setOptions(1, charset) < 0) {
                    throw new SQLWarning(TSDBConstants.WrapErrMsg("Failed to set charset: " + charset + ". System default will be used."));
                }
                if (TSDBJNIConnector.setOptions(2, timezone) < 0) {
                    throw new SQLWarning(TSDBConstants.WrapErrMsg("Failed to set timezone: " + timezone + ". System default will be used."));
                }
                isInitialized = true;
                TaosGlobalConfig.setCharset(TSDBJNIConnector.getTsCharset());
            }
        }
    }

    public static native void initImp(String var0);

    public static native int setOptions(int var0, String var1);

    public static native String getTsCharset();

    public boolean connect(String host, int port, String dbName, String user, String password) throws SQLException {
        if (this.taos != 0L) {
            this.closeConnectionImp(this.taos);
            this.taos = 0L;
        }
        this.taos = this.connectImp(host, port, dbName, user, password);
        if (this.taos == 0L) {
            throw new SQLException(TSDBConstants.WrapErrMsg(this.getErrMsg()), "", this.getErrCode());
        }
        return true;
    }

    private native long connectImp(String var1, int var2, String var3, String var4, String var5);

    public int executeQuery(String sql) throws SQLException {
        int code;
        long resultSetPointer;
        if (!this.isResultsetClosed && (resultSetPointer = this.getResultSet()) != -2L) {
            this.freeResultSet(resultSetPointer);
        }
        try {
            code = this.executeQueryImp(sql.getBytes(TaosGlobalConfig.getCharset()), this.taos);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(TSDBConstants.WrapErrMsg("Unsupported encoding"));
        }
        this.affectedRows = code;
        if (code < 0) {
            this.affectedRows = -1;
            if (code == -1) {
                throw new SQLException(TSDBConstants.WrapErrMsg(this.getErrMsg()), "", this.getErrCode());
            }
            throw new SQLException(TSDBConstants.FixErrMsg(code), "", this.getErrCode());
        }
        return code;
    }

    private native int executeQueryImp(byte[] var1, long var2);

    public int getErrCode() {
        return Math.abs(this.getErrCodeImp(this.taos));
    }

    private native int getErrCodeImp(long var1);

    public String getErrMsg() {
        return this.getErrMsgImp(this.taos);
    }

    private native String getErrMsgImp(long var1);

    public long getResultSet() {
        long res = this.getResultSetImp(this.taos);
        return res;
    }

    private native long getResultSetImp(long var1);

    public int freeResultSet(long result) {
        int res = this.freeResultSetImp(this.taos, result);
        this.isResultsetClosed = true;
        return res;
    }

    private native int freeResultSetImp(long var1, long var3);

    public int getAffectedRows() {
        int affectedRows = this.affectedRows;
        if (affectedRows < 0) {
            affectedRows = this.getAffectedRowsImp(this.taos);
        }
        return affectedRows;
    }

    private native int getAffectedRowsImp(long var1);

    public int getSchemaMetaData(long resultSet, List<ColumnMetaData> columnMetaData) {
        return this.getSchemaMetaDataImp(this.taos, resultSet, columnMetaData);
    }

    private native int getSchemaMetaDataImp(long var1, long var3, List<ColumnMetaData> var5);

    public int fetchRow(long resultSet, TSDBResultSetRowData rowData) {
        return this.fetchRowImp(this.taos, resultSet, rowData);
    }

    private native int fetchRowImp(long var1, long var3, TSDBResultSetRowData var5);

    public void closeConnection() throws SQLException {
        int code = this.closeConnectionImp(this.taos);
        if (code < 0) {
            throw new SQLException(TSDBConstants.FixErrMsg(code), "", this.getErrCode());
        }
        if (code != 0) {
            throw new SQLException("Undefined error code returned by TDengine when closing a connection");
        }
        this.taos = 0L;
    }

    private native int closeConnectionImp(long var1);

    public long subscribe(String host, String user, String password, String database, String table, long time, int period) {
        return this.subscribeImp(host, user, password, database, table, time, period);
    }

    private native long subscribeImp(String var1, String var2, String var3, String var4, String var5, long var6, int var8);

    public TSDBResultSetRowData consume(long subscription) {
        return this.consumeImp(subscription);
    }

    private native TSDBResultSetRowData consumeImp(long var1);

    public void unsubscribe(long subscription) {
        this.unsubscribeImp(subscription);
    }

    private native void unsubscribeImp(long var1);

    public boolean validateCreateTableSql(String sql) {
        long connection = this.taos;
        int res = this.validateCreateTableSqlImp(connection, sql.getBytes());
        return res == 0;
    }

    private native int validateCreateTableSqlImp(long var1, byte[] var3);

    static {
        System.loadLibrary("taos");
    }
}

