/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class TSDBStatement
implements Statement {
    private TSDBJNIConnector connecter = null;
    protected List<String> batchedArgs;
    protected int queryTimeout = 0;

    TSDBStatement(TSDBJNIConnector connecter) {
        this.connecter = connecter;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.connecter.executeQuery(sql);
        long resultSetPointer = this.connecter.getResultSet();
        if (resultSetPointer == -2L) {
            throw new SQLException(TSDBConstants.FixErrMsg(-2));
        }
        if (resultSetPointer == 0L) {
            return null;
        }
        return new TSDBResultSet(this.connecter, resultSetPointer);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.connecter.executeQuery(sql);
    }

    public String getErrorMsg() {
        return this.connecter.getErrMsg();
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeUpdate(sql) == 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        long resultSetPointer = this.connecter.getResultSet();
        TSDBResultSet resSet = null;
        if (resultSetPointer != 0L) {
            resSet = new TSDBResultSet(this.connecter, resultSetPointer);
        }
        return resSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.connecter.getAffectedRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 4096;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList<String>();
        }
        this.batchedArgs.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchedArgs.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchedArgs == null) {
            throw new SQLException(TSDBConstants.WrapErrMsg("Batch is empty!"));
        }
        int[] res = new int[this.batchedArgs.size()];
        for (int i = 0; i < this.batchedArgs.size(); ++i) {
            res[i] = this.executeUpdate(this.batchedArgs.get(i));
        }
        return res;
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }
}

