/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBDatabaseMetaData;
import com.taosdata.jdbc.TSDBJNIConnector;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class TSDBDriver
implements Driver {
    @Deprecated
    private static final String URL_PREFIX1 = "jdbc:TSDB://";
    private static final String URL_PREFIX = "jdbc:TAOS://";
    public static final String PROPERTY_KEY_DBNAME = "dbname";
    public static final String PROPERTY_KEY_HOST = "host";
    public static final String PROPERTY_KEY_PASSWORD = "password";
    public static final String PROPERTY_KEY_PORT = "port";
    public static final String PROPERTY_KEY_USER = "user";
    public static final String PROPERTY_KEY_CONFIG_DIR = "cfgdir";
    public static final String PROPERTY_KEY_TIME_ZONE = "timezone";
    public static final String PROPERTY_KEY_LOCALE = "locale";
    public static final String PROPERTY_KEY_CHARSET = "charset";
    public static final String PROPERTY_KEY_PROTOCOL = "protocol";
    public static final int PORT_NUMBER_INDEX = 1;
    public static final int HOST_NAME_INDEX = 0;
    private TSDBDatabaseMetaData dbMetaData = null;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw new SQLException(TSDBConstants.WrapErrMsg("url is not set!"));
        }
        Properties props = null;
        props = this.parseURL(url, info);
        if (props == null) {
            return null;
        }
        try {
            TSDBJNIConnector.init((String)props.get(PROPERTY_KEY_CONFIG_DIR), (String)props.get(PROPERTY_KEY_LOCALE), (String)props.get(PROPERTY_KEY_CHARSET), (String)props.get(PROPERTY_KEY_TIME_ZONE));
            TSDBConnection newConn = new TSDBConnection(props, this.dbMetaData);
            return newConn;
        }
        catch (SQLWarning sqlWarning) {
            sqlWarning.printStackTrace();
            TSDBConnection newConn = new TSDBConnection(props, this.dbMetaData);
            return newConn;
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            SQLException sqlEx = new SQLException("SQLException:" + ex.toString());
            sqlEx.initCause(ex);
            throw sqlEx;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String[] parseHostPortPair(String hostPortPair) throws SQLException {
        String[] splitValues = new String[2];
        int portIndex = hostPortPair.indexOf(":");
        String hostname = null;
        if (portIndex != -1) {
            if (portIndex + 1 >= hostPortPair.length()) throw new SQLException(TSDBConstants.WrapErrMsg("port is not proper!"));
            String portAsString = hostPortPair.substring(portIndex + 1);
            splitValues[0] = hostname = hostPortPair.substring(0, portIndex);
            splitValues[1] = portAsString;
            return splitValues;
        } else {
            splitValues[0] = hostPortPair;
            splitValues[1] = null;
        }
        return splitValues;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return StringUtils.isNotBlank((CharSequence)url) && url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (url != null && (url.startsWith(URL_PREFIX) || url.startsWith(URL_PREFIX1))) {
            info = this.parseURL(url, info);
        }
        DriverPropertyInfo hostProp = new DriverPropertyInfo(PROPERTY_KEY_HOST, info.getProperty(PROPERTY_KEY_HOST));
        hostProp.required = true;
        DriverPropertyInfo portProp = new DriverPropertyInfo(PROPERTY_KEY_PORT, info.getProperty(PROPERTY_KEY_PORT, "6200"));
        portProp.required = false;
        DriverPropertyInfo dbProp = new DriverPropertyInfo(PROPERTY_KEY_DBNAME, info.getProperty(PROPERTY_KEY_DBNAME));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo userProp = new DriverPropertyInfo(PROPERTY_KEY_USER, info.getProperty(PROPERTY_KEY_USER));
        userProp.required = true;
        DriverPropertyInfo passwordProp = new DriverPropertyInfo(PROPERTY_KEY_PASSWORD, info.getProperty(PROPERTY_KEY_PASSWORD));
        passwordProp.required = true;
        DriverPropertyInfo[] propertyInfo = new DriverPropertyInfo[]{hostProp, portProp, dbProp, userProp, passwordProp};
        return propertyInfo;
    }

    public Properties parseURL(String url, Properties defaults) throws SQLException {
        String[] queryStrings;
        String[] kvPair;
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? defaults : new Properties();
        if (url == null) {
            return null;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)URL_PREFIX) && !StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)URL_PREFIX1)) {
            return null;
        }
        String urlForMeta = url;
        String dbProductName = url.substring(url.indexOf(":") + 1);
        dbProductName = dbProductName.substring(0, dbProductName.indexOf(":"));
        int beginningOfSlashes = url.indexOf("//");
        url = url.substring(beginningOfSlashes + 2);
        String host = url.substring(0, url.indexOf(":"));
        url = url.substring(url.indexOf(":") + 1);
        urlProps.setProperty(PROPERTY_KEY_HOST, host);
        String port = url.substring(0, url.indexOf("/"));
        urlProps.setProperty(PROPERTY_KEY_PORT, port);
        url = url.substring(url.indexOf("/") + 1);
        if (url.indexOf("?") == -1) {
            if (!url.trim().isEmpty()) {
                String dbName = url.trim();
                urlProps.setProperty(PROPERTY_KEY_DBNAME, dbName);
            }
            this.dbMetaData = new TSDBDatabaseMetaData(dbProductName, urlForMeta, urlProps.getProperty(PROPERTY_KEY_USER));
            return urlProps;
        }
        String dbName = url.substring(0, url.indexOf("?"));
        urlProps.setProperty(PROPERTY_KEY_DBNAME, dbName);
        url = url.trim().substring(url.indexOf("?") + 1);
        String user = "";
        if (url.indexOf("&") == -1 && (kvPair = url.trim().split("=")).length == 2) {
            this.setPropertyValue(urlProps, kvPair);
            return urlProps;
        }
        for (String queryStr : queryStrings = url.trim().split("&")) {
            String[] kvPair2 = queryStr.trim().split("=");
            if (kvPair2.length < 2) continue;
            this.setPropertyValue(urlProps, kvPair2);
        }
        user = urlProps.getProperty(PROPERTY_KEY_USER).toString();
        this.dbMetaData = new TSDBDatabaseMetaData(dbProductName, urlForMeta, user);
        return urlProps;
    }

    public void setPropertyValue(Properties property, String[] keyValuePair) {
        switch (keyValuePair[0].toLowerCase()) {
            case "user": {
                property.setProperty(PROPERTY_KEY_USER, keyValuePair[1]);
                break;
            }
            case "password": {
                property.setProperty(PROPERTY_KEY_PASSWORD, keyValuePair[1]);
                break;
            }
            case "timezone": {
                property.setProperty(PROPERTY_KEY_TIME_ZONE, keyValuePair[1]);
                break;
            }
            case "locale": {
                property.setProperty(PROPERTY_KEY_LOCALE, keyValuePair[1]);
                break;
            }
            case "charset": {
                property.setProperty(PROPERTY_KEY_CHARSET, keyValuePair[1]);
                break;
            }
            case "cfgdir": {
                property.setProperty(PROPERTY_KEY_CONFIG_DIR, keyValuePair[1]);
            }
        }
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public String host(Properties props) {
        return props.getProperty(PROPERTY_KEY_HOST, "localhost");
    }

    public int port(Properties props) {
        return Integer.parseInt(props.getProperty(PROPERTY_KEY_PORT, "6200"));
    }

    public String database(Properties props) {
        return props.getProperty(PROPERTY_KEY_DBNAME);
    }

    static {
        try {
            DriverManager.registerDriver(new TSDBDriver());
        }
        catch (SQLException E) {
            throw new RuntimeException(TSDBConstants.WrapErrMsg("can't register tdengine jdbc driver!"));
        }
    }
}

