/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Comparator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RDNNameValuePair
implements Comparable<RDNNameValuePair>,
Comparator<RDNNameValuePair>,
Serializable {
    private static final long serialVersionUID = -8780852504883527870L;
    private final ASN1OctetString attributeValue;
    private final Schema schema;
    private final String attributeName;
    private volatile String lowerAttributeName;
    private volatile String normalizedString;
    private volatile String stringRepresentation;

    RDNNameValuePair(String attributeName, ASN1OctetString attributeValue, Schema schema) {
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.schema = schema;
        this.lowerAttributeName = null;
        this.normalizedString = null;
        this.stringRepresentation = null;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    String getLowercaseAttributeName() {
        if (this.lowerAttributeName == null) {
            this.lowerAttributeName = StaticUtils.toLowerCase(this.attributeName);
        }
        return this.lowerAttributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue.stringValue();
    }

    public byte[] getAttributeValueBytes() {
        return this.attributeValue.getValue();
    }

    public ASN1OctetString getRawAttributeValue() {
        return this.attributeValue;
    }

    @Override
    public int compareTo(RDNNameValuePair p) {
        String thatLowerName;
        String thisLowerName = this.getLowercaseAttributeName();
        int nameComparison = thisLowerName.compareTo(thatLowerName = p.getLowercaseAttributeName());
        if (nameComparison != 0) {
            return nameComparison;
        }
        String thisNormalizedString = this.toNormalizedString();
        String thatNormalizedString = p.toNormalizedString();
        return thisNormalizedString.compareTo(thatNormalizedString);
    }

    @Override
    public int compare(RDNNameValuePair p1, RDNNameValuePair p2) {
        return p1.compareTo(p2);
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RDNNameValuePair)) {
            return false;
        }
        RDNNameValuePair p = (RDNNameValuePair)o;
        return this.toNormalizedString().equals(p.toNormalizedString());
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer, false);
            this.stringRepresentation = buffer.toString();
        }
        return this.stringRepresentation;
    }

    public String toMinimallyEncodedString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer, boolean minimizeEncoding) {
        if (this.stringRepresentation != null && !minimizeEncoding) {
            buffer.append(this.stringRepresentation);
            return;
        }
        boolean bufferWasEmpty = buffer.length() == 0;
        buffer.append(this.attributeName);
        buffer.append('=');
        RDN.appendValue(buffer, this.attributeValue, minimizeEncoding);
        if (bufferWasEmpty && !minimizeEncoding) {
            this.stringRepresentation = buffer.toString();
        }
    }

    public String toNormalizedString() {
        if (this.normalizedString == null) {
            StringBuilder buffer = new StringBuilder();
            this.toNormalizedString(buffer);
            this.normalizedString = buffer.toString();
        }
        return this.normalizedString;
    }

    public void toNormalizedString(StringBuilder buffer) {
        buffer.append(this.getLowercaseAttributeName());
        buffer.append('=');
        RDN.appendNormalizedValue(buffer, this.attributeName, this.attributeValue, this.schema);
    }
}

